/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import weightedgpa.infinibiome.api.Infinibiome;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.DependencyModule;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.nonworldgen.FileConfig;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.dependency.DependencyInjectorImpl;
import weightedgpa.infinibiome.internal.display.DisplayMapBase;
import weightedgpa.infinibiome.internal.generators.DefaultModule;
import weightedgpa.infinibiome.internal.generators.nonworldgen.FileConfigImpl;
import weightedgpa.infinibiome.internal.generators.posdata.LakeGen;
import weightedgpa.infinibiome.internal.generators.posdata.MushroomIslandGen;
import weightedgpa.infinibiome.internal.minecraftImpl.world.NullWorld;

abstract class DataMapBase
extends DisplayMapBase {
    protected final PosDataProvider posData;
    protected final DependencyInjector di;

    DataMapBase(int scale, String seedBranch) {
        super(scale);
        Seed seed = Seed.ROOT.newSeed(seedBranch);
        ArrayList<DependencyModule> depManager = new ArrayList<DependencyModule>();
        depManager.add(DefaultModule.INSTANCE);
        depManager.add(t -> {
            t.addItem(Seed.class, __ -> seed);
            t.addItem(FileConfig.class, __ -> new FileConfigImpl(Lists.newArrayList((Object[])new DependencyModule[]{DefaultModule.INSTANCE})));
            t.addItem(ChunkGenerator.class, __ -> new NullChunkGenerator());
            t.blacklist(o -> o instanceof LakeGen);
            t.blacklist(o -> o instanceof MushroomIslandGen);
        });
        this.di = new DependencyInjectorImpl(depManager).initInjectorIgnoreErrors();
        Infinibiome.initKeys();
        this.posData = this.di.get(PosDataProvider.class);
    }

    static {
        Bootstrap.func_151354_b();
    }

    private class NullChunkGenerator
    extends ChunkGenerator<GenerationSettings> {
        private NullChunkGenerator() {
            super((IWorld)new NullWorld(), null, null);
        }

        public int func_205470_d() {
            return 0;
        }

        public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        }

        public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk) {
        }

        public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
            return 0;
        }
    }
}

