/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.atomic.AtomicBoolean;
import weightedgpa.infinibiome.internal.display.ShiftImage;
import weightedgpa.infinibiome.internal.misc.ProgressPrinter;

abstract class DisplayMapBase
extends Applet
implements KeyListener,
MouseListener {
    private ShiftImage<Color> image = null;
    final int scale;

    DisplayMapBase(int scale) {
        this.scale = scale;
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    protected abstract Color getColor(int var1, int var2, int var3, int var4);

    protected Object displayStringAt(int x, int z) {
        return "";
    }

    protected void onFinished() {
    }

    @Override
    public void paint(Graphics graphic) {
        if (this.image == null) {
            this.image = new ShiftImage<Color>(this.getWidth(), this.getHeight(), (x, z) -> this.getColor(x * this.scale, z * this.scale, x, z));
        }
        ProgressPrinter progressPrinter = new ProgressPrinter(this.getWidth() * this.getHeight());
        AtomicBoolean lock = new AtomicBoolean(false);
        this.image.iterParallel((x, z, color) -> {
            while (!lock.compareAndSet(false, true)) {
            }
            graphic.setColor((Color)color);
            graphic.fillRect(x, z, 1, 1);
            lock.set(false);
            progressPrinter.incrementAndTryPrintProgress();
        });
        this.onFinished();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.image.shift(0, -this.getHeight() / 2);
        }
        if (e.getKeyCode() == 40) {
            this.image.shift(0, this.getHeight() / 2);
        }
        if (e.getKeyCode() == 37) {
            this.image.shift(-this.getWidth() / 2, 0);
        }
        if (e.getKeyCode() == 39) {
            this.image.shift(this.getWidth() / 2, 0);
        }
        this.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int x = (mouseEvent.getX() + this.image.getXOffset()) * this.scale;
        int z = (mouseEvent.getY() + this.image.getZOffset()) * this.scale;
        this.showStatus(String.format("%s %s %s", x, z, this.displayStringAt(x, z)));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

