/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.atomic.AtomicIntegerArray;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.ProgressPrinter;

public final class Distribution
extends Applet {
    private final FloatFunc<BlockPos2D> base;
    private final AtomicIntegerArray counter;

    public Distribution() {
        this(Distribution.initNoise(), 20, 1000000000);
    }

    private static FloatFunc<BlockPos2D> initNoise() {
        return Helper.initUniformNoise(Seed.ROOT, 20.48);
    }

    private Distribution(FloatFunc<BlockPos2D> base, int smoothness, int sampleSize) {
        this.base = base;
        this.counter = new AtomicIntegerArray(smoothness);
        assert (base.getOutputInterval().canMapInterval());
        this.generateCounter(sampleSize);
    }

    private void generateCounter(int sampleSize) {
        int length = (int)Math.sqrt(sampleSize);
        ProgressPrinter progressPrinter = new ProgressPrinter(sampleSize);
        Helper.iterXZParallel(length, length, (x, z) -> {
            BlockPos2D input = new BlockPos2D((int)x, (int)z);
            double output = this.base.getOutput(input);
            int index = this.base.getOutputInterval().mapToIntInterval(output, 0, this.counter.length() - 1);
            this.counter.incrementAndGet(index);
            progressPrinter.incrementAndTryPrintProgress();
        });
    }

    int getMaxCount() {
        int result = this.counter.get(0);
        for (int i = 1; i < this.counter.length(); ++i) {
            if (this.counter.get(i) <= result) continue;
            result = this.counter.get(i);
        }
        return result;
    }

    @Override
    public void paint(Graphics g) {
        Interval xPixelInterval = new Interval(5.0, this.getWidth() - 5);
        Interval yPixelInterval = new Interval(5.0, this.getHeight() - 5);
        Interval indexInterval = new Interval(0.0, this.counter.length() - 1);
        Interval countInterval = new Interval(0.0, this.getMaxCount());
        for (int y = 0; y < this.getHeight(); y += 2) {
            g.setColor(Color.RED);
            g.fillRect((int)xPixelInterval.getMidPoint(), y, 1, 1);
        }
        for (int i = 0; i < this.counter.length(); ++i) {
            int count = this.counter.get(i);
            int xPixel = (int)indexInterval.mapInterval(i, xPixelInterval);
            int yPixel = (int)countInterval.mapInterval(countInterval.getMax() - (double)count, yPixelInterval);
            g.setColor(Color.BLACK);
            g.fillRect(xPixel, yPixel, 1, 1);
        }
    }
}

