/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.awt.Color;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.display.DisplayMapBase;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.Interpolation;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class FloatFuncMap
extends DisplayMapBase {
    private final FloatFunc<BlockPos2D> noise;

    public FloatFuncMap() {
        this(1, FloatFuncMap.getNoise());
    }

    private static FloatFunc<BlockPos2D> getNoise() {
        return new Interpolation<BlockPos2D>(new RandomGen(Seed.ROOT).asPercentFloatFunc(BlockPos2D.INFO), 32, 1, BlockPos2D.INFO);
    }

    private FloatFuncMap(int scale, FloatFunc<BlockPos2D> noise) {
        super(scale);
        this.noise = noise;
    }

    @Override
    protected Color getColor(int posX, int posZ, int screenPixelX, int screenPixelZ) {
        float color = (float)this.noise.getOutputInterval().mapInterval(this.noise.getOutput(new BlockPos2D(posX, posZ)), Interval.PERCENT);
        return new Color(color, color, color);
    }
}

