/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.awt.Color;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.display.DataMapBase;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class HeightMap
extends DataMapBase {
    private static final Interval OCEAN_HEIGHT = new Interval(8.0, 63.0);
    private static final Interval LAND_HEIGHT = new Interval(63.0, 213.0);

    public HeightMap() {
        this(40, "2");
    }

    private HeightMap(int scale, String seedBranch) {
        super(scale, seedBranch);
    }

    @Override
    protected Color getColor(int posX, int posZ, int screenPixelX, int screenPixelZ) {
        if (posX % 1000 == 0 || posZ % 1000 == 0) {
            return Color.BLACK;
        }
        double height = this.posData.get(PosDataKeys.MAPPED_HEIGHT, new BlockPos2D(posX, posZ));
        try {
            if (height > 63.0) {
                double v = LAND_HEIGHT.mapInterval(height, Interval.PERCENT);
                if (v > 1.0) {
                    v = 1.0;
                }
                return new Color(0.0f, (float)v, 0.0f);
            }
            double v = OCEAN_HEIGHT.mapInterval(height, Interval.PERCENT);
            return new Color(0.0f, 0.0f, (float)v);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.valueOf(height), e);
        }
    }
}

