/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.util.function.Function;
import java.util.function.Supplier;
import weightedgpa.infinibiome.internal.misc.Helper;

final class ShiftImage<T> {
    private final int xLength;
    private final int zLength;
    private final NewFunc<? extends T> newFunc;
    private int xOffset = 0;
    private int zOffset = 0;
    private Array<Array<T>> rowColumn;

    ShiftImage(int xLength, int zLength, NewFunc<? extends T> newFunc) {
        this.xLength = xLength;
        this.zLength = zLength;
        this.newFunc = newFunc;
        this.rowColumn = new Array<Array>(xLength, i -> new Array(zLength));
    }

    public void shift(int xOffset, int zOffset) {
        this.xOffset += xOffset;
        this.zOffset += zOffset;
        ShiftImage.shift(this.rowColumn, xOffset, () -> new Array(this.zLength));
        for (int i = 0; i < this.xLength; ++i) {
            ShiftImage.shift(this.rowColumn.get(i), zOffset, () -> null);
        }
    }

    int getXOffset() {
        return this.xOffset;
    }

    int getZOffset() {
        return this.zOffset;
    }

    void iter(Consumer<? super T> iterFunc) {
        for (int x = 0; x < this.xLength; ++x) {
            for (int z = 0; z < this.zLength; ++z) {
                T item = this.rowColumn.get(x).get(z);
                if (item == null) {
                    item = this.newFunc.produce(x + this.xOffset, z + this.zOffset);
                    this.rowColumn.get(x).set(z, item);
                }
                iterFunc.accept(x, z, item);
            }
        }
    }

    void iterParallel(Consumer<? super T> iterFunc) {
        Helper.iterXZParallel(this.xLength, this.zLength, (x, z) -> {
            T item = this.rowColumn.get((int)x).get((int)z);
            if (item == null) {
                item = this.newFunc.produce(x + this.xOffset, z + this.zOffset);
                this.rowColumn.get((int)x).set((int)z, item);
            }
            iterFunc.accept((int)x, (int)z, (T)item);
        });
    }

    private static <T> void shift(Array<T> original, int offset, Supplier<T> newT) {
        int i;
        Array<T> result = new Array<T>(original.getLength());
        for (i = 0; i < original.getLength(); ++i) {
            int offsetI = i + offset;
            if (offsetI < 0 || offsetI >= original.getLength()) {
                result.set(i, newT.get());
                continue;
            }
            result.set(i, original.get(offsetI));
        }
        for (i = 0; i < original.getLength(); ++i) {
            original.set(i, result.get(i));
        }
    }

    private static class Array<T> {
        final Object[] arr;

        Array(int length) {
            this.arr = new Object[length];
        }

        Array(int length, Function<Integer, T> toDefault) {
            this.arr = new Object[length];
            for (int i = 0; i < this.arr.length; ++i) {
                this.arr[i] = toDefault.apply(i);
            }
        }

        int getLength() {
            return this.arr.length;
        }

        T get(int index) {
            return (T)this.arr[index];
        }

        void set(int index, T item) {
            this.arr[index] = item;
        }
    }

    @FunctionalInterface
    static interface Consumer<T> {
        public void accept(int var1, int var2, T var3);
    }

    static interface NewFunc<T> {
        public T produce(int var1, int var2);
    }
}

