/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.awt.Color;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.display.DataMapBase;
import weightedgpa.infinibiome.internal.generators.interchunks.tree.TreeGens;

public final class TreeDensityMap
extends DataMapBase {
    private final TreeGens treeGens;

    public TreeDensityMap() {
        this(1, "67");
    }

    private TreeDensityMap(int scale, String seedBranch) {
        super(scale, seedBranch);
        this.treeGens = this.di.get(TreeGens.class);
    }

    @Override
    protected Color getColor(int posX, int posZ, int screenPixelX, int screenPixelZ) {
        InterChunkPos interChunkPos = new InterChunkPos(posX, posZ);
        BlockPos2D pos = interChunkPos.getLowestCenterBlockPos();
        if (this.posData.get(PosDataKeys.LANDMASS_TYPE, pos).isOcean()) {
            return Color.BLUE;
        }
        if (PosDataHelper.isUnderwaterPortionOfLakeOrRiver(pos, this.posData)) {
            return Color.BLUE;
        }
        float treeDensity = (float)this.treeGens.getApproxDensity(interChunkPos);
        return new Color(treeDensity, treeDensity, treeDensity);
    }
}

