/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.util.function.Function;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.CubicNoise;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.PercentileTable;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class UniformMap
extends Applet {
    private static final int LENGTH = 800;
    private final Function<Double, Color> func;
    private final float[] values;
    private final PercentileTable percentileTable;
    private final int scale;

    public UniformMap() {
        this(UniformMap.initNoise(), UniformMap::getColor, 1, 1024);
    }

    private UniformMap(FloatFunc<BlockPos2D> noise, Function<Double, Color> func, int scale, int fineness) {
        this.func = func;
        this.scale = scale;
        this.values = new float[640000];
        Helper.iterXZParallel(800, 800, (x, z) -> {
            this.values[x.intValue() * 800 + z.intValue()] = (float)noise.getOutput(new BlockPos2D(x * scale, z * scale));
        });
        this.percentileTable = PercentileTable.generate(this.values, fineness);
    }

    private static FloatFunc<BlockPos2D> initNoise() {
        CubicNoise<BlockPos2D> n1 = new CubicNoise<BlockPos2D>(Seed.ROOT, 50.0, BlockPos2D.INFO);
        FloatFunc n2 = new CubicNoise<BlockPos2D>(Seed.ROOT.newSeed("2"), 50.0, BlockPos2D.INFO).mapInterval(new Interval(0.0, 1.0));
        FloatFunc n3 = new CubicNoise<BlockPos2D>(Seed.ROOT.newSeed("3"), 50.0, BlockPos2D.INFO).mapInterval(new Interval(0.0, 1.0));
        return input -> MathHelper.fractal(i -> n1.getOutput((BlockPos2D)input, (double)i), n1.getOutputInterval(), 5.0, 0.5, 0.5);
    }

    private static Color getColor(double percent) {
        if (PosDataHelper.FREEZE_INTERVAL.contains(percent)) {
            return new Color(255, 255, 255);
        }
        if (PosDataHelper.COLD_INTERVAL.contains(percent)) {
            return new Color(70, 100, 100);
        }
        if (PosDataHelper.WARM_INTERVAL.contains(percent)) {
            return new Color(0, 150, 0);
        }
        return new Color(0, 70, 0);
    }

    @Override
    public void paint(Graphics graphics) {
        for (int x = 0; x < 800; ++x) {
            for (int z = 0; z < 800; ++z) {
                double value = this.values[x * 800 + z];
                value = this.percentileTable.rawValueToPercentile(value);
                graphics.setColor(this.func.apply(value));
                graphics.fillRect(x, z, 1, 1);
            }
        }
    }
}

