/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc;

import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.floatfunc.IntFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.PercentileTable;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.MathHelper;

@FunctionalInterface
public interface FloatFunc<I> {
    public double getOutput(I var1);

    default public Interval getOutputInterval() {
        return Interval.ALL_VALUES;
    }

    public static <I> FloatFunc<I> constFunc(final double value) {
        final Interval outputInterval = new Interval(value, value);
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                return value;
            }

            @Override
            public Interval getOutputInterval() {
                return outputInterval;
            }
        };
    }

    default public FloatFunc<I> mapInterval(final Interval newInterval) {
        if (newInterval.getSize() == 0.0) {
            return FloatFunc.constFunc(newInterval.getMin());
        }
        Validate.isTrue(this.getOutputInterval().canMapInterval());
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                double baseOutput = FloatFunc.this.getOutput(input);
                return FloatFunc.this.getOutputInterval().mapInterval(baseOutput, newInterval);
            }

            @Override
            public Interval getOutputInterval() {
                return newInterval;
            }
        };
    }

    default public IntFunc<I> mapToIntInterval(final int min, final int max) {
        Validate.isTrue(min <= max);
        Validate.isTrue(this.getOutputInterval().canMapInterval());
        final Interval outputInterval = new Interval(min, max);
        return new IntFunc<I>(){

            @Override
            public int getIntOutput(I input) {
                return FloatFunc.this.getOutputInterval().mapToIntInterval(FloatFunc.this.getOutput(input), min, max);
            }

            @Override
            public Interval getOutputInterval() {
                return outputInterval;
            }
        };
    }

    default public FloatFunc<I> mapToSubInterval(final FloatFunc<I> intervalPosition, final FloatFunc<I> intervalLength) {
        Validate.isTrue(Interval.PERCENT.containsAll(intervalPosition.getOutputInterval()));
        Validate.isTrue(intervalLength.getOutputInterval().getMin() >= 0.0);
        Validate.isTrue(intervalLength.getOutputInterval().getMax() <= this.getOutputInterval().getSize());
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                Interval newInterval = FloatFunc.this.getOutputInterval().subInterval(intervalLength.getOutput(input), intervalPosition.getOutput(input));
                return FloatFunc.this.getOutputInterval().mapInterval(FloatFunc.this.getOutput(input), newInterval);
            }

            @Override
            public Interval getOutputInterval() {
                return FloatFunc.this.getOutputInterval();
            }
        };
    }

    default public <NI> FloatFunc<NI> mapInput(final Function<NI, I> mapFunc) {
        return new FloatFunc<NI>(){

            @Override
            public double getOutput(NI input) {
                Object baseInput = mapFunc.apply(input);
                return FloatFunc.this.getOutput(baseInput);
            }

            @Override
            public Interval getOutputInterval() {
                return FloatFunc.this.getOutputInterval();
            }
        };
    }

    default public FloatFunc<I> skew(final FloatFunc<I> skewFunc) {
        Validate.isTrue(this.getOutputInterval().canMapInterval());
        if (skewFunc.getOutputInterval().isConstant() && skewFunc.getOutputInterval().getMin() == 0.0) {
            return this;
        }
        if (this.getOutputInterval().equals(Interval.PERCENT)) {
            return new FloatFunc<I>(){

                @Override
                public double getOutput(I input) {
                    return MathHelper.skew(FloatFunc.this.getOutput(input), skewFunc.getOutput(input));
                }

                @Override
                public Interval getOutputInterval() {
                    return FloatFunc.this.getOutputInterval();
                }
            };
        }
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                double baseOutput = FloatFunc.this.getOutput(input);
                double baseOutputPercent = FloatFunc.this.getOutputInterval().mapInterval(baseOutput, Interval.PERCENT);
                baseOutputPercent = MathHelper.skew(baseOutputPercent, skewFunc.getOutput(input));
                return Interval.PERCENT.mapInterval(baseOutputPercent, FloatFunc.this.getOutputInterval());
            }

            @Override
            public Interval getOutputInterval() {
                return FloatFunc.this.getOutputInterval();
            }
        };
    }

    default public IntFunc<I> randomRound(Seed seed, final IntPosInfo<I> posInfo) {
        seed = seed.newSeed("randomRound");
        Validate.isTrue(this.getOutputInterval().getMin() >= 0.0);
        final RandomGen randomProducer = new RandomGen(seed);
        final Interval outputInterval = new Interval(0.0, StrictMath.ceil(this.getOutputInterval().getMax() * 2.0));
        return new IntFunc<I>(){

            @Override
            public int getIntOutput(I input) {
                Random random = randomProducer.getRandom(posInfo.getIntX(input), posInfo.getIntZ(input));
                return MathHelper.randomRound(FloatFunc.this.getOutput(input), random);
            }

            @Override
            public Interval getOutputInterval() {
                return outputInterval;
            }
        };
    }

    default public Predicate<I> randomBool(IntPosInfo<I> posInfo, Seed seed) {
        Validate.isTrue(Interval.PERCENT.containsAll(this.getOutputInterval()));
        seed = seed.newSeed("probability");
        RandomGen randomProducer = new RandomGen(seed);
        return input -> {
            double chance = this.getOutput(input);
            Random random = randomProducer.getRandom(posInfo.getIntX(input), posInfo.getIntZ(input));
            return MathHelper.randomBool(chance, random);
        };
    }

    @SafeVarargs
    public static <I> FloatFunc<I> multiply(final FloatFunc<I> ... floatFuncs) {
        final Interval outputInterval = FloatFunc._applyOp((a, b) -> a * b, floatFuncs);
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                double result = 1.0;
                for (FloatFunc floatFunc : floatFuncs) {
                    if ((result *= floatFunc.getOutput(input)) != 0.0) continue;
                    return 0.0;
                }
                return result;
            }

            @Override
            public Interval getOutputInterval() {
                return outputInterval;
            }
        };
    }

    @SafeVarargs
    public static <I> FloatFunc<I> sum(final FloatFunc<I> ... floatFuncs) {
        final Interval outputInterval = FloatFunc._applyOp((a, b) -> a + b, floatFuncs);
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                double result = 0.0;
                for (FloatFunc floatFunc : floatFuncs) {
                    result += floatFunc.getOutput(input);
                }
                return result;
            }

            @Override
            public Interval getOutputInterval() {
                return outputInterval;
            }
        };
    }

    default public FloatFunc<I> toUniform(final PercentileTable table) {
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                double output = FloatFunc.this.getOutput(input);
                return table.rawValueToPercentile(output);
            }

            @Override
            public Interval getOutputInterval() {
                return Interval.PERCENT;
            }
        };
    }

    default public FloatFunc<I> _setDebuggable(String group, String name, Function<BlockPos2D, I> blockPosToI) {
        DebugCommand.registerDebugFunc(group, name, p -> String.valueOf(this.getOutput(blockPosToI.apply((BlockPos2D)p))));
        return this;
    }

    default public FloatFunc<I> _setDebuggable(String group, String name, BiFunction<FloatFunc<I>, BlockPos2D, String> display) {
        DebugCommand.registerDebugFunc(group, name, p -> (String)display.apply(this, (BlockPos2D)p));
        return this;
    }

    public static <I> Interval _applyOp(BiFunction<Double, Double, Double> func, FloatFunc<I> ... floatFuncs) {
        Interval result = floatFuncs[0].getOutputInterval();
        for (int i = 1; i < floatFuncs.length; ++i) {
            FloatFunc<I> floatFunc = floatFuncs[i];
            result = Interval.applyOp(result, floatFunc.getOutputInterval(), func::apply);
        }
        return result;
    }
}

