/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.generators;

import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class CubicNoise<I>
implements FloatFunc<I> {
    public static final Interval OUTPUT_INTERVAL = new Interval(-1.0, 1.0);
    private final RawNoise noise;
    private final double inverseScale;
    private final PosInfo<I> posInfo;

    public CubicNoise(Seed seed, double scale, PosInfo<I> posInfo) {
        seed = seed.newSeed("cubicNoise");
        this.posInfo = posInfo;
        this.noise = new RawNoise(seed.getAsInt());
        this.inverseScale = 1.0 / scale;
    }

    @Override
    public double getOutput(I input) {
        return this.noise.sample(this.posInfo.getX(input) * this.inverseScale, this.posInfo.getZ(input) * this.inverseScale);
    }

    public double getOutput(I input, double scale) {
        return this.noise.sample(this.posInfo.getX(input) * this.inverseScale * (1.0 / scale), this.posInfo.getZ(input) * this.inverseScale * (1.0 / scale));
    }

    @Override
    public Interval getOutputInterval() {
        return OUTPUT_INTERVAL;
    }

    private static class RawNoise {
        private static final int RND_A = 134775813;
        private static final int RND_B = 1103515245;
        private final int seed;

        RawNoise(int seed) {
            this.seed = seed;
        }

        double sample(double x, double y) {
            int xi = (int)Math.floor(x);
            double lerpx = x - (double)xi;
            int yi = (int)Math.floor(y);
            double lerpy = y - (double)yi;
            double[] xSamples = new double[4];
            for (int i = 0; i < 4; ++i) {
                xSamples[i] = RawNoise.interpolate(RawNoise.randomize(this.seed, xi - 1, yi - 1 + i), RawNoise.randomize(this.seed, xi, yi - 1 + i), RawNoise.randomize(this.seed, xi + 1, yi - 1 + i), RawNoise.randomize(this.seed, xi + 2, yi - 1 + i), lerpx);
            }
            return RawNoise.interpolate(xSamples[0], xSamples[1], xSamples[2], xSamples[3], lerpy);
        }

        private static double randomize(int seed, int x, int y) {
            return (double)(((x ^ y) * 134775813 ^ seed + x) * (1103515245 * x << 16 ^ 1103515245 * y - 134775813)) / 2.147483647E9;
        }

        private static double interpolate(double a, double b, double c, double d, double x) {
            double p = d - c - (a - b);
            return x * (x * (x * p + (a - b - p)) + (c - a)) + b;
        }
    }
}

