/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.generators;

import java.util.Random;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.PercentileTable;
import weightedgpa.infinibiome.internal.misc.Helper;

public final class PerlinNoise<I>
implements FloatFunc<I> {
    private static final Interval OUTPUT_INTERVAL = new Interval(-0.68f, 0.68f);
    public static final PercentileTable PERCENTILE_TABLE = PercentileTable.deserialize(Helper.getResource("/perlinPercentileTable"));
    private final RawNoise rawNoise;
    private final double inverseScale;
    private final PosInfo<I> posInfo;

    public PerlinNoise(Seed seed, double scale, PosInfo<I> posInfo) {
        seed = seed.newSeed("perlinNoise");
        this.rawNoise = new RawNoise(seed.getAsInt());
        this.inverseScale = 1.0 / scale;
        this.posInfo = posInfo;
    }

    @Override
    public double getOutput(I input) {
        double value = this.rawNoise.noise(this.posInfo.getX(input) * this.inverseScale, this.posInfo.getZ(input) * this.inverseScale);
        return OUTPUT_INTERVAL.clamp(value);
    }

    @Override
    public Interval getOutputInterval() {
        return OUTPUT_INTERVAL;
    }

    private static final class RawNoise {
        private static final int P = 8;
        private static final int B = 256;
        private static final int M = 255;
        private static final int NP = 8;
        private static final int N = 256;
        private static final int NM = 255;
        private int[] p = new int[514];
        private double[][] g2 = new double[514][2];
        private double[] g1 = new double[514];
        private int start = 1;
        private double[][] points = new double[32][3];

        public RawNoise(int seed) {
            int j;
            int k;
            int i;
            Random r = new Random(seed);
            for (i = 0; i < 256; ++i) {
                double W;
                double V;
                double U;
                double Lo;
                double Hi;
                double w;
                double v;
                double u;
                this.p[i] = i;
                this.g1[i] = 2.0f * r.nextFloat() - 1.0f;
                while ((u = (double)(2.0f * r.nextFloat() - 1.0f)) * u + (v = (double)(2.0f * r.nextFloat() - 1.0f)) * v > 1.0 || Math.abs(u) > 2.5 * Math.abs(v) || Math.abs(v) > 2.5 * Math.abs(u) || Math.abs(Math.abs(u) - Math.abs(v)) < 0.4) {
                }
                this.g2[i][0] = u;
                this.g2[i][1] = v;
                this.normalize2(this.g2[i]);
                do {
                    u = 2.0f * r.nextFloat() - 1.0f;
                    v = 2.0f * r.nextFloat() - 1.0f;
                    w = 2.0f * r.nextFloat() - 1.0f;
                    U = Math.abs(u);
                    V = Math.abs(v);
                    W = Math.abs(w);
                    Lo = Math.min(U, Math.min(V, W));
                    Hi = Math.max(U, Math.max(V, W));
                } while (u * u + v * v + w * w > 1.0 || Hi > 4.0 * Lo || Math.min(Math.abs(U - V), Math.min(Math.abs(U - W), Math.abs(V - W))) < 0.2);
            }
            while (--i > 0) {
                k = this.p[i];
                j = (int)(r.nextLong() & 0xFFL);
                this.p[i] = this.p[j];
                this.p[j] = k;
            }
            for (i = 0; i < 258; ++i) {
                this.p[256 + i] = this.p[i];
                this.g1[256 + i] = this.g1[i];
                for (j = 0; j < 2; ++j) {
                    this.g2[256 + i][j] = this.g2[i][j];
                }
            }
            double d = Math.sqrt(0.3333333333333333);
            this.points[3][2] = d;
            this.points[3][1] = d;
            this.points[3][0] = d;
            double r2 = Math.sqrt(0.5);
            double s = Math.sqrt(2.0 + r2 + r2);
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.points[i][j] = (i == j ? 1.0 + r2 + r2 : r2) / s;
                }
            }
            for (i = 0; i <= 1; ++i) {
                for (j = 0; j <= 1; ++j) {
                    for (k = 0; k <= 1; ++k) {
                        int n = i + j * 2 + k * 4;
                        if (n <= 0) continue;
                        for (int m = 0; m < 4; ++m) {
                            this.points[4 * n + m][0] = (double)(i == 0 ? 1 : -1) * this.points[m][0];
                            this.points[4 * n + m][1] = (double)(j == 0 ? 1 : -1) * this.points[m][1];
                            this.points[4 * n + m][2] = (double)(k == 0 ? 1 : -1) * this.points[m][2];
                        }
                    }
                }
            }
        }

        private double lerp(double t, double a, double b) {
            return a + t * (b - a);
        }

        private double s_curve(double t) {
            return t * t * (3.0 - t - t);
        }

        public double noise(double x) {
            double t = x + 256.0;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            double rx0 = t - (double)((int)t);
            double rx1 = rx0 - 1.0;
            double sx = this.s_curve(rx0);
            double u = rx0 * this.g1[this.p[bx0]];
            double v = rx1 * this.g1[this.p[bx1]];
            return this.lerp(sx, u, v);
        }

        public double noise(double x, double y) {
            double t = x + 256.0;
            int bx0 = (int)t & 0xFF;
            int bx1 = bx0 + 1 & 0xFF;
            double rx0 = t - (double)((int)t);
            double rx1 = rx0 - 1.0;
            t = y + 256.0;
            int by0 = (int)t & 0xFF;
            int by1 = by0 + 1 & 0xFF;
            double ry0 = t - (double)((int)t);
            double ry1 = ry0 - 1.0;
            int i = this.p[bx0];
            int j = this.p[bx1];
            int b00 = this.p[i + by0];
            int b10 = this.p[j + by0];
            int b01 = this.p[i + by1];
            int b11 = this.p[j + by1];
            double sx = this.s_curve(rx0);
            double sy = this.s_curve(ry0);
            double[] q = this.g2[b00];
            double u = rx0 * q[0] + ry0 * q[1];
            q = this.g2[b10];
            double v = rx1 * q[0] + ry0 * q[1];
            double a = this.lerp(sx, u, v);
            q = this.g2[b01];
            u = rx0 * q[0] + ry1 * q[1];
            q = this.g2[b11];
            v = rx1 * q[0] + ry1 * q[1];
            double b = this.lerp(sx, u, v);
            return this.lerp(sy, a, b);
        }

        public double noise(double x, double y, double z) {
            int bx = (int)Math.IEEEremainder(Math.floor(x), 256.0);
            if (bx < 0) {
                bx += 256;
            }
            double rx0 = x - Math.floor(x);
            double rx1 = rx0 - 1.0;
            int by = (int)Math.IEEEremainder(Math.floor(y), 256.0);
            if (by < 0) {
                by += 256;
            }
            double ry0 = y - Math.floor(y);
            double ry1 = ry0 - 1.0;
            int bz = (int)Math.IEEEremainder(Math.floor(z), 256.0);
            if (bz < 0) {
                bz += 256;
            }
            double rz = z - Math.floor(z);
            int b0 = this.p[bx];
            int b1 = this.p[++bx];
            int b00 = this.p[b0 + by];
            int b10 = this.p[b1 + by];
            int b01 = this.p[b0 + ++by];
            int b11 = this.p[b1 + by];
            double sx = this.s_curve(rx0);
            double sy = this.s_curve(ry0);
            double sz = this.s_curve(rz);
            double[] q = this.G(b00 + bz);
            double u = rx0 * q[0] + ry0 * q[1] + rz * q[2];
            q = this.G(b10 + bz);
            double v = rx1 * q[0] + ry0 * q[1] + rz * q[2];
            double a = this.lerp(sx, u, v);
            q = this.G(b01 + bz);
            u = rx0 * q[0] + ry1 * q[1] + rz * q[2];
            q = this.G(b11 + bz);
            v = rx1 * q[0] + ry1 * q[1] + rz * q[2];
            double b = this.lerp(sx, u, v);
            double c = this.lerp(sy, a, b);
            q = this.G(b00 + ++bz);
            u = rx0 * q[0] + ry0 * q[1] + (rz -= 1.0) * q[2];
            q = this.G(b10 + bz);
            v = rx1 * q[0] + ry0 * q[1] + rz * q[2];
            a = this.lerp(sx, u, v);
            q = this.G(b01 + bz);
            u = rx0 * q[0] + ry1 * q[1] + rz * q[2];
            q = this.G(b11 + bz);
            v = rx1 * q[0] + ry1 * q[1] + rz * q[2];
            b = this.lerp(sx, u, v);
            double d = this.lerp(sy, a, b);
            return this.lerp(sz, c, d);
        }

        private double[] G(int i) {
            return this.points[i % 32];
        }

        private void normalize2(double[] v) {
            double s = Math.sqrt(v[0] * v[0] + v[1] * v[1]);
            v[0] = v[0] / s;
            v[1] = v[1] / s;
        }
    }
}

