/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.generators;

import java.util.Random;
import net.openhft.hashing.LongHashFunction;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class RandomGen {
    private final LongHashFunction hasher;

    public RandomGen(Seed seed) {
        seed = seed.newSeed("randomGen");
        this.hasher = LongHashFunction.xx(seed.getAsInt());
    }

    public <I> FloatFunc<I> asPercentFloatFunc(final IntPosInfo<I> posInfo) {
        return new FloatFunc<I>(){

            @Override
            public double getOutput(I input) {
                return RandomGen.this.getPercent(posInfo.getIntX(input), posInfo.getIntZ(input));
            }

            @Override
            public Interval getOutputInterval() {
                return Interval.PERCENT;
            }
        };
    }

    public int getRandomInt(int x, int z) {
        int merged = x << 16 | z & 0xFFFF;
        return (int)this.hasher.hashInt(merged);
    }

    public Random getRandom(int x, int z) {
        return new Random(this.getRandomInt(x, z));
    }

    public double getPercent(int x, int z) {
        return (double)(this.getRandomInt(x, z) & 0xFFFFFF) / 1.6777216E7;
    }
}

