/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.modifiers;

import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.misc.PosModCache;

public final class Interpolation<I>
implements FloatFunc<I> {
    private final FloatFunc<I> base;
    private final IntPosInfo<I> posinfo;
    private final int gridLengthLog2;
    private final int gridLength;
    private final PosModCache<GridPos, Double> gridCornerCache;
    private final PosModCache<GridPos, Grid> gridDataCache;

    public Interpolation(FloatFunc<I> base, int gridLength, int cacheLength, IntPosInfo<I> posInfo) {
        this.base = base;
        this.posinfo = posInfo;
        this.gridLength = gridLength;
        this.gridLengthLog2 = Log2helper.asLog2(gridLength);
        this.gridDataCache = new PosModCache<GridPos, Grid>(cacheLength, x$0 -> new Grid((GridPos)x$0), GridPos.INFO);
        this.gridCornerCache = new PosModCache<GridPos, Double>(cacheLength, p -> base.getOutput(this.posinfo.build(Log2helper.mult(((GridPos)p).x, this.gridLengthLog2), Log2helper.mult(((GridPos)p).z, this.gridLengthLog2))), GridPos.INFO);
    }

    @Override
    public double getOutput(I input) {
        int posX = this.posinfo.getIntX(input);
        int posZ = this.posinfo.getIntZ(input);
        int modX = Log2helper.mod(posX, this.gridLengthLog2);
        int modZ = Log2helper.mod(posZ, this.gridLengthLog2);
        int divX = Log2helper.floorDiv(posX, this.gridLengthLog2);
        int divZ = Log2helper.floorDiv(posZ, this.gridLengthLog2);
        return this.gridDataCache.get(new GridPos(divX, divZ)).values[modX][modZ];
    }

    private double s_curve(double t) {
        return t * t * (3.0 - t - t);
    }

    @Override
    public Interval getOutputInterval() {
        return this.base.getOutputInterval();
    }

    private class Grid {
        private final double[][] values;

        private Grid(GridPos pos) {
            this.values = new double[Interpolation.this.gridLength][Interpolation.this.gridLength];
            double v00 = (Double)Interpolation.this.gridCornerCache.get(pos);
            double v10 = (Double)Interpolation.this.gridCornerCache.get(new GridPos(pos.x + 1, pos.z));
            double v01 = (Double)Interpolation.this.gridCornerCache.get(new GridPos(pos.x, pos.z + 1));
            double v11 = (Double)Interpolation.this.gridCornerCache.get(new GridPos(pos.x + 1, pos.z + 1));
            for (int x = 0; x < Interpolation.this.gridLength; ++x) {
                for (int z = 0; z < Interpolation.this.gridLength; ++z) {
                    double percentX = Interpolation.this.s_curve((double)x / (double)Interpolation.this.gridLength);
                    double percentZ = Interpolation.this.s_curve((double)z / (double)Interpolation.this.gridLength);
                    this.values[x][z] = MathHelper.lerp(percentX, MathHelper.lerp(percentZ, v00, v01), MathHelper.lerp(percentZ, v10, v11));
                }
            }
        }
    }

    private static class GridPos {
        static IntPosInfo<GridPos> INFO = new IntPosInfo<GridPos>(){

            @Override
            public int getIntX(GridPos pos) {
                return pos.x;
            }

            @Override
            public int getIntZ(GridPos pos) {
                return pos.z;
            }

            @Override
            public int getLog2Scale() {
                throw new UnsupportedOperationException();
            }

            @Override
            public GridPos build(int x, int z) {
                throw new UnsupportedOperationException();
            }
        };
        private final int x;
        private final int z;

        GridPos(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

