/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.modifiers;

import java.util.ArrayList;
import java.util.List;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.floatfunc.util.IntervalMapper;

public final class IntervalMapperWrapper<I>
implements FloatFunc<I> {
    private final FloatFunc<I> base;
    private final double defaultValue;
    private final List<Interval> intervals = new ArrayList<Interval>();
    private final List<Outputs> outputs = new ArrayList<Outputs>();
    private Interval outputInterval;

    public IntervalMapperWrapper(FloatFunc<I> base) {
        this(base, 0.0);
    }

    public IntervalMapperWrapper(FloatFunc<I> base, double defaultValue) {
        this.base = base;
        this.defaultValue = defaultValue;
        this.outputInterval = new Interval(defaultValue, defaultValue);
    }

    public IntervalMapperWrapper<I> addBranch(Interval captureInterval, double captureRangeMinConvert, double captureRangeMaxConvert) {
        this.intervals.add(captureInterval);
        this.outputs.add(new Outputs(captureRangeMinConvert, captureRangeMaxConvert));
        this.outputInterval = this.outputInterval.union(new Interval(captureRangeMinConvert, captureRangeMaxConvert));
        return this;
    }

    @Override
    public double getOutput(I input) {
        IntervalMapper<Object> intervalMapper = new IntervalMapper<Object>(() -> this.defaultValue);
        double baseValue = this.base.getOutput(input);
        int i = 0;
        while (i < this.intervals.size()) {
            int i_ = i++;
            intervalMapper.addBranch(__ -> this.intervals.get(i_), interval -> this.outputs.get(i_).convert(baseValue, interval));
        }
        return (Double)intervalMapper.run(baseValue);
    }

    @Override
    public Interval getOutputInterval() {
        return this.outputInterval;
    }

    private static final class Outputs {
        private final double lowerValueConvert;
        private final double upperValueConvert;

        Outputs(double lowerValueConvert, double upperValueConvert) {
            this.lowerValueConvert = lowerValueConvert;
            this.upperValueConvert = upperValueConvert;
        }

        private double convert(double baseValue, Interval captureInterval) {
            return captureInterval.mapInterval(baseValue, this.lowerValueConvert, this.upperValueConvert);
        }
    }
}

