/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.modifiers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.Pair;
import weightedgpa.infinibiome.internal.misc.ProgressPrinter;

public final class SeamlessGrid
implements Serializable {
    private final int gridLength;
    private final int gridLengthLog2;
    private final int smoothLength;
    private final float[][][][] overlaps;
    private final RelativeGrid[] allRelativeGrid;

    private SeamlessGrid(int gridLength, int smoothRadius) {
        Validate.isTrue(gridLength > 0, "gridLength must be greater than 0", new Object[0]);
        Validate.isTrue(smoothRadius > 0, "smoothRadius must be greater than 0", new Object[0]);
        Validate.isTrue(smoothRadius <= gridLength, "transitionRadius must not be greater than gridLength", new Object[0]);
        this.gridLengthLog2 = Log2helper.asLog2(gridLength);
        this.gridLength = gridLength;
        this.smoothLength = smoothRadius;
        this.allRelativeGrid = this.initAllGrids();
        this.overlaps = new float[gridLength][gridLength][3][3];
    }

    public static SeamlessGrid generate(int gridLength, int smoothRadius) {
        SeamlessGrid result = new SeamlessGrid(gridLength, smoothRadius);
        result.generateOverlaps();
        return result;
    }

    public static SeamlessGrid deserialize(DataInput input) throws IOException {
        int gridLength = input.readInt();
        int smoothRadius = input.readInt();
        SeamlessGrid result = new SeamlessGrid(gridLength, smoothRadius);
        result.loadOverlaps(input);
        return result;
    }

    public void serialize(DataOutput output) throws IOException {
        output.writeInt(this.gridLength);
        output.writeInt(this.smoothLength);
        for (RelativeSmoothingCircle pos : this.allPossibleRelativeSmoothingCircles()) {
            for (RelativeGrid grid : this.allRelativeGrid) {
                output.writeFloat(this.overlaps[pos.getArrayX()][pos.getArrayZ()][grid.getArrayX()][grid.getArrayZ()]);
            }
        }
    }

    public <I> double getValue(I pos, Function<I, Double> gridLowestPosToValue, IntPosInfo<I> posInfo) {
        RelativeSmoothingCircle smoothingCircle = new RelativeSmoothingCircle(pos, posInfo);
        double aggregatedValue = 0.0;
        for (RelativeGrid grid : this.allRelativeGrid) {
            double percent = this.getOverlap(smoothingCircle, grid);
            if (percent == 0.0) continue;
            I gridLowestPos = grid.getNonRelativeGridLowestPos(pos, posInfo);
            double baseOutput = gridLowestPosToValue.apply(gridLowestPos);
            aggregatedValue += baseOutput * percent;
        }
        return aggregatedValue;
    }

    public String _debugValue(BlockPos2D pos, Function<? super BlockPos2D, Double> gridLowestPosToValue) {
        ArrayList<Pair> outputWithPercents = new ArrayList<Pair>();
        RelativeSmoothingCircle smoothingCircle = new RelativeSmoothingCircle(pos, BlockPos2D.INFO);
        for (RelativeGrid grid : this.allRelativeGrid) {
            double percent = this.getOverlap(smoothingCircle, grid);
            BlockPos2D gridLowestPos = grid.getNonRelativeGridLowestPos(pos, BlockPos2D.INFO);
            double output = gridLowestPosToValue.apply(gridLowestPos);
            outputWithPercents.add(new Pair<Double, Double>(output, percent));
        }
        outputWithPercents.sort(Comparator.comparing(p -> -((Double)p.second).doubleValue()));
        String result = "";
        for (Pair outputWithPercent : outputWithPercents) {
            if ((Double)outputWithPercent.second < (double)0.1f) continue;
            result = result + String.format("%s%%: %.2f, ", Math.round((Double)outputWithPercent.second * 100.0), outputWithPercent.first);
        }
        return result;
    }

    private Collection<RelativeSmoothingCircle> allPossibleRelativeSmoothingCircles() {
        ArrayList<RelativeSmoothingCircle> result = new ArrayList<RelativeSmoothingCircle>();
        for (int x = 0; x < this.gridLength; ++x) {
            for (int z = 0; z < this.gridLength; ++z) {
                result.add(new RelativeSmoothingCircle(x, z));
            }
        }
        return result;
    }

    private RelativeGrid[] initAllGrids() {
        ArrayList<RelativeGrid> result = new ArrayList<RelativeGrid>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                result.add(new RelativeGrid(x, z));
            }
        }
        return result.toArray(new RelativeGrid[0]);
    }

    private double getOverlap(RelativeSmoothingCircle smoothingCircle, RelativeGrid grid) {
        return this.overlaps[smoothingCircle.getArrayX()][smoothingCircle.getArrayZ()][grid.getArrayX()][grid.getArrayZ()];
    }

    private void loadOverlaps(DataInput input) throws IOException {
        for (RelativeSmoothingCircle smoothingCircle : this.allPossibleRelativeSmoothingCircles()) {
            for (RelativeGrid grid : this.allRelativeGrid) {
                this.overlaps[smoothingCircle.getArrayX()][smoothingCircle.getArrayZ()][grid.getArrayX()][grid.getArrayZ()] = input.readFloat();
            }
        }
    }

    private void generateOverlaps() {
        ProgressPrinter progressPrinter = new ProgressPrinter((long)this.gridLength * (long)this.gridLength * 3L * 3L);
        for (RelativeSmoothingCircle smoothingCircle : this.allPossibleRelativeSmoothingCircles()) {
            for (RelativeGrid grid : this.allRelativeGrid) {
                double overlap = this.generateOverlap(smoothingCircle, grid);
                this.overlaps[smoothingCircle.getArrayX()][smoothingCircle.getArrayZ()][grid.getArrayX()][grid.getArrayZ()] = (float)overlap;
                progressPrinter.incrementAndTryPrintProgress();
            }
        }
    }

    private double generateOverlap(RelativeSmoothingCircle smoothingCircle, RelativeGrid grid) {
        double intersectionArea = smoothingCircle.getGeometry().intersection(grid.getGeometry()).getArea();
        return intersectionArea / smoothingCircle.getGeometry().getArea();
    }

    private class RelativeSmoothingCircle {
        private final int centerX;
        private final int centerZ;
        private Object circleGeometry = null;

        RelativeSmoothingCircle(int centerX, int centerZ) {
            this.centerX = centerX;
            this.centerZ = centerZ;
        }

        <T> RelativeSmoothingCircle(T pos, IntPosInfo<T> posInfo) {
            this.centerX = Log2helper.mod(posInfo.getIntX(pos), SeamlessGrid.this.gridLengthLog2);
            this.centerZ = Log2helper.mod(posInfo.getIntZ(pos), SeamlessGrid.this.gridLengthLog2);
        }

        int getArrayX() {
            return this.centerX;
        }

        int getArrayZ() {
            return this.centerZ;
        }

        Geometry getGeometry() {
            if (this.circleGeometry == null) {
                GeometricShapeFactory factory = new GeometricShapeFactory();
                factory.setCentre(new Coordinate(this.centerX, this.centerZ));
                factory.setSize(SeamlessGrid.this.smoothLength * 2);
                this.circleGeometry = factory.createCircle();
            }
            return (Geometry)this.circleGeometry;
        }
    }

    private class RelativeGrid {
        final int lowestX;
        final int lowestZ;
        final int gridX;
        final int gridZ;
        private Object geometry = null;

        RelativeGrid(int gridX, int gridZ) {
            this.gridX = gridX;
            this.gridZ = gridZ;
            this.lowestX = gridX * SeamlessGrid.this.gridLength;
            this.lowestZ = gridZ * SeamlessGrid.this.gridLength;
        }

        <I> I getNonRelativeGridLowestPos(I pos, IntPosInfo<I> posInfo) {
            int nonRelativeCenterGridLowestX = posInfo.getIntX(pos) - Log2helper.mod(posInfo.getIntX(pos), SeamlessGrid.this.gridLengthLog2);
            int nonRelativeCenterGridLowestZ = posInfo.getIntZ(pos) - Log2helper.mod(posInfo.getIntZ(pos), SeamlessGrid.this.gridLengthLog2);
            return posInfo.build(nonRelativeCenterGridLowestX + this.lowestX, nonRelativeCenterGridLowestZ + this.lowestZ);
        }

        int getArrayX() {
            return this.gridX + 1;
        }

        int getArrayZ() {
            return this.gridZ + 1;
        }

        Geometry getGeometry() {
            if (this.geometry == null) {
                GeometricShapeFactory factory = new GeometricShapeFactory();
                factory.setSize(SeamlessGrid.this.gridLength);
                double centerX = (double)this.lowestX + (double)SeamlessGrid.this.gridLength / 2.0;
                double centerZ = (double)this.lowestZ + (double)SeamlessGrid.this.gridLength / 2.0;
                factory.setCentre(new Coordinate(centerX, centerZ));
                this.geometry = factory.createRectangle();
            }
            return (Geometry)this.geometry;
        }
    }
}

