/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.test;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc_;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise_;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public class Test {
    static final FloatFunc<BlockPos2D> noise1;
    static final FloatFunc_ noise2;
    static final BlockPos2D.Mutable pos;
    static final Random random;

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void run1(Blackhole b) {
        double base = 2.0 + random.nextDouble() * 1024.0;
        b.consume(Math.log(2.0 + random.nextDouble() * 1024.0) / Math.log(base));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Fork(value=1)
    public void run2(Blackhole b, X x) {
        pos.setPos(x.x, x.x);
        b.consume(noise2.getOutput(pos.getBlockX(), pos.getBlockZ()));
        ++x.x;
    }

    static {
        Seed seed = Seed.ROOT.copyWithoutWarnings();
        noise1 = new SimplexNoise<BlockPos2D>(seed, 2.0, BlockPos2D.INFO).mapToSubInterval(new SimplexNoise<BlockPos2D>(seed.newSeed("1"), 2.0, BlockPos2D.INFO).mapInterval(Interval.PERCENT), new SimplexNoise<BlockPos2D>(seed.newSeed("2"), 2.0, BlockPos2D.INFO).mapInterval(Interval.PERCENT));
        seed = Seed.ROOT.copyWithoutWarnings();
        noise2 = new SimplexNoise_(seed).mapToSubInterval(new SimplexNoise_(seed.newSeed("1")).mapInterval(Interval.PERCENT), new SimplexNoise_(seed.newSeed("2")).mapInterval(Interval.PERCENT));
        pos = new BlockPos2D.Mutable();
        random = new Random(0L);
    }

    @State(value=Scope.Benchmark)
    public static class X {
        int x = 0;
    }
}

