/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nullable;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class Interval {
    public static final Interval ALL_VALUES = new Interval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Interval POSITIVES = new Interval(Math.nextUp(0.0f), Double.POSITIVE_INFINITY);
    public static final Interval NON_NEGATIVES = new Interval(0.0, Double.POSITIVE_INFINITY);
    public static final Interval PERCENT = new Interval(0.0, 1.0);
    private final double min;
    private final double max;

    public Interval(double value1, double value2) {
        assert (!Double.isNaN(value1));
        assert (!Double.isNaN(value2));
        if (value1 < value2) {
            this.min = value1;
            this.max = value2;
        } else {
            this.min = value2;
            this.max = value1;
        }
    }

    public Interval subInterval(double length, double center) {
        assert (PERCENT.contains(center));
        assert (length >= 0.0);
        assert (length <= this.getSize());
        Interval resultCenterInterval = new Interval(this.getMin() + length / 2.0, this.getMax() - length / 2.0);
        double resultCenter = PERCENT.mapInterval(center, resultCenterInterval);
        return new Interval(resultCenter - length / 2.0, resultCenter + length / 2.0);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMidPoint() {
        return (this.max + this.min) / 2.0;
    }

    public double getSize() {
        return this.max - this.min;
    }

    public boolean contains(double value) {
        return this.getMin() <= value && this.getMax() >= value;
    }

    public boolean canMapInterval() {
        return this.getSize() != 0.0 && Double.isFinite(this.getSize());
    }

    public double mapInterval(double value, Interval newInterval) {
        return this.mapInterval(value, newInterval.getMin(), newInterval.getMax());
    }

    public double mapInterval(double value, double minConvert, double maxConvert) {
        assert (Double.isFinite(value));
        assert (Double.isFinite(minConvert));
        assert (Double.isFinite(maxConvert));
        double slope = (maxConvert - minConvert) / this.getSize();
        double offset = -this.getMin() * slope + minConvert;
        return value * slope + offset;
    }

    public int mapToIntInterval(double value, int min, int maxInclusive) {
        assert (Double.isFinite(value));
        double preResult = this.mapInterval(value, new Interval(min, maxInclusive + 1));
        int result = MathHelper.floor(preResult);
        if (result == maxInclusive + 1) {
            return maxInclusive;
        }
        return result;
    }

    public double clamp(double base) {
        assert (!Double.isNaN(base));
        if (base > this.getMax()) {
            return this.getMax();
        }
        if (base < this.getMin()) {
            return this.getMin();
        }
        return base;
    }

    public double foldClamp(double base) {
        assert (Double.isFinite(base)) : base;
        if (this.contains(base)) {
            return base;
        }
        if (base < this.getMin()) {
            return this.foldClamp(this.getMin() + (this.getMin() - base));
        }
        assert (base > this.getMax());
        return this.foldClamp(this.getMax() - (base - this.getMax()));
    }

    public Interval union(Interval other) {
        return new Interval(Math.min(this.getMin(), other.getMin()), Math.max(this.getMax(), other.getMax()));
    }

    @Nullable
    public Interval intersection(Interval interval2) {
        double resultMax;
        double resultMin = Math.max(this.getMin(), interval2.getMin());
        if (resultMin > (resultMax = Math.min(this.getMax(), interval2.getMax()))) {
            return null;
        }
        return new Interval(resultMin, resultMax);
    }

    public Interval initBehind(double length) {
        assert (length >= 0.0) : length;
        return new Interval(this.getMin() - length, this.getMin());
    }

    public Interval initAhead(double length) {
        assert (length >= 0.0) : length;
        return new Interval(this.getMax(), this.getMax() + length);
    }

    public Interval applyOp(DoubleUnaryOperator function) {
        double minApplied = function.applyAsDouble(this.getMin());
        double maxApplied = function.applyAsDouble(this.getMax());
        return new Interval(minApplied, maxApplied);
    }

    public static Interval union(Interval interval0, Interval ... intervals) {
        Interval result = interval0;
        for (Interval interval : intervals) {
            result = result.union(interval);
        }
        return result;
    }

    public static Interval applyOp(Interval interval1, Interval interval2, DoubleBinaryOperator function) {
        ArrayList list = Lists.newArrayList((Object[])new Double[]{function.applyAsDouble(interval1.getMin(), interval2.getMin()), function.applyAsDouble(interval1.getMax(), interval2.getMin()), function.applyAsDouble(interval1.getMin(), interval2.getMax()), function.applyAsDouble(interval1.getMax(), interval2.getMax())});
        double upperBound = (Double)list.stream().max(Double::compare).get();
        double lowerBound = (Double)list.stream().min(Double::compare).get();
        return new Interval(lowerBound, upperBound);
    }

    public boolean containsAll(Interval other) {
        return this.getMax() >= other.getMax() && this.getMin() <= other.getMin();
    }

    public boolean containsAny(Interval other) {
        return this.intersection(other) != null;
    }

    public String toString() {
        return String.format("Interval[min=%s, max=%s]", this.getMin(), this.getMax());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return Double.compare(interval.getMin(), this.getMin()) == 0 && Double.compare(interval.getMax(), this.getMax()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getMin(), this.getMax());
    }

    public boolean isConstant() {
        return this.getMax() == this.getMin();
    }
}

