/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class IntervalMapper<T> {
    private final Supplier<T> defaultOutput;
    private final List<Function<Neighbors, Interval>> intervalProducers = new ArrayList<Function<Neighbors, Interval>>();
    private final List<Function<Interval, T>> outputProducers = new ArrayList<Function<Interval, T>>();

    public IntervalMapper(Supplier<T> defaultOutput) {
        this.defaultOutput = defaultOutput;
    }

    public IntervalMapper<T> addBranch(@Nullable Function<Neighbors, Interval> intervalProducer, Function<Interval, T> outputProducer) {
        this.intervalProducers.add(intervalProducer);
        this.outputProducers.add(outputProducer);
        return this;
    }

    public T run(double value) {
        Interval[] intervals = new Interval[this.outputProducers.size()];
        while (!this.allInit(intervals)) {
            for (int i = 0; i < intervals.length; ++i) {
                intervals[i] = this.intervalProducers.get(i).apply(new Neighbors(i, intervals));
                if (intervals[i] == null || !intervals[i].contains(value)) continue;
                return this.outputProducers.get(i).apply(intervals[i]);
            }
        }
        return this.defaultOutput.get();
    }

    private boolean allInit(Interval[] intervals) {
        for (Interval i : intervals) {
            if (i != null) continue;
            return false;
        }
        return true;
    }

    public final class Neighbors {
        final int currPosition;
        final Interval[] intervals;

        private Neighbors(int currPosition, Interval[] intervals) {
            this.currPosition = currPosition;
            this.intervals = intervals;
        }

        @Nullable
        public Interval between() {
            Interval prev = this.getPrevInterval();
            if (prev == null) {
                return null;
            }
            Interval next = this.getNextInterval();
            if (next == null) {
                return null;
            }
            return new Interval(prev.getMax(), next.getMin());
        }

        @Nullable
        public Interval getNextInterval() {
            if (this.currPosition == this.intervals.length - 1) {
                throw new RuntimeException("cant get between");
            }
            if (this.intervals[this.currPosition + 1] == null) {
                return null;
            }
            return this.intervals[this.currPosition + 1];
        }

        @Nullable
        public Interval getPrevInterval() {
            if (this.currPosition == 0) {
                throw new RuntimeException("cant get between");
            }
            if (this.intervals[this.currPosition - 1] == null) {
                return null;
            }
            return this.intervals[this.currPosition - 1];
        }
    }
}

