/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.floatfunc.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicLongArray;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.ProgressPrinter;

public final class PercentileTable {
    public final float[] valueToPercentile;
    private final Interval interval;

    private PercentileTable(DataInput file) throws IOException {
        this.valueToPercentile = new float[file.readInt()];
        for (int i = 0; i < this.valueToPercentile.length; ++i) {
            this.valueToPercentile[i] = file.readFloat();
        }
        this.interval = new Interval(file.readFloat(), file.readFloat());
    }

    private PercentileTable(FloatFunc<? super BlockPos2D> base, int fineness, long sampleSize) {
        this.interval = base.getOutputInterval();
        AtomicLongArray counter = this.generateCounter(base, fineness, sampleSize);
        this.printCounterStat(counter);
        this.valueToPercentile = this.generateTable(counter, fineness, sampleSize);
    }

    private PercentileTable(int fineness, float[] values) {
        this.interval = this.getRawNoiseInterval(values);
        AtomicLongArray counter = this.generateCounter(values, fineness);
        this.printCounterStat(counter);
        this.valueToPercentile = this.generateTable(counter, fineness, values.length);
    }

    public static PercentileTable generate(FloatFunc<BlockPos2D> base, int fineness, long sampleSize) {
        return new PercentileTable(base, fineness, sampleSize);
    }

    public static PercentileTable generate(float[] values, int fineness) {
        return new PercentileTable(fineness, values);
    }

    public double rawValueToPercentile(double rawValue) {
        assert (this.interval.contains(rawValue)) : rawValue + " not in " + this.interval;
        int index = this.interval.mapToIntInterval(rawValue, 0, this.valueToPercentile.length - 1);
        return this.valueToPercentile[index];
    }

    public double percentileToRawNoise(double percentile) {
        int resultIndex = 0;
        double resultDist = Math.abs((double)this.valueToPercentile[resultIndex] - percentile);
        for (int thisIndex = 1; thisIndex < this.valueToPercentile.length; ++thisIndex) {
            double thisDist = Math.abs((double)this.valueToPercentile[thisIndex] - percentile);
            if (!(thisDist < resultDist)) continue;
            resultIndex = thisIndex;
            resultDist = thisDist;
        }
        return Interval.PERCENT.mapInterval((double)resultIndex / (double)this.valueToPercentile.length, this.interval);
    }

    public Interval getRawNoiseInterval() {
        return this.interval;
    }

    public static PercentileTable deserialize(DataInput input) {
        try {
            return new PercentileTable(input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serialize(DataOutput output) {
        try {
            ProgressPrinter progressPrinter = new ProgressPrinter(this.valueToPercentile.length);
            output.writeInt(this.valueToPercentile.length);
            for (int i = 0; i < this.valueToPercentile.length; ++i) {
                output.writeFloat(this.valueToPercentile[i]);
                progressPrinter.incrementAndTryPrintProgress();
            }
            output.writeFloat((float)this.interval.getMin());
            output.writeFloat((float)this.interval.getMax());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private AtomicLongArray generateCounter(FloatFunc<? super BlockPos2D> base, int fineness, long sampleSize) {
        AtomicLongArray result = new AtomicLongArray(fineness);
        int length = (int)Math.sqrt(sampleSize);
        ProgressPrinter progressPrinter = new ProgressPrinter(sampleSize);
        Helper.iterXZParallel(length * 32, length / 32, (x, z) -> {
            BlockPos2D input = new BlockPos2D((int)x, (int)z);
            double output = base.getOutput(input);
            result.incrementAndGet(this.interval.mapToIntInterval(output, 0, result.length() - 1));
            progressPrinter.incrementAndTryPrintProgress();
        });
        return result;
    }

    private void printCounterStat(AtomicLongArray counter) {
    }

    private AtomicLongArray generateCounter(float[] values, int fineness) {
        AtomicLongArray result = new AtomicLongArray(fineness);
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            result.incrementAndGet(this.interval.mapToIntInterval(v, 0, result.length() - 1));
        }
        return result;
    }

    private float[] generateTable(AtomicLongArray counter, int fineness, long sampleSize) {
        assert (counter.length() == fineness);
        float[] result = new float[fineness];
        ProgressPrinter progressPrinter = new ProgressPrinter(result.length);
        long accumulation = 0L;
        for (int i = 0; i < result.length; ++i) {
            double percentile = (double)(accumulation += counter.get(i)) / (double)sampleSize;
            assert (percentile >= 0.0);
            assert (percentile <= 1.0);
            result[i] = (float)percentile;
            progressPrinter.incrementAndTryPrintProgress();
        }
        return result;
    }

    private Interval getRawNoiseInterval(float[] values) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double v = fArray[i];
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        return new Interval(min, max);
    }
}

