/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ChunkGen;
import weightedgpa.infinibiome.api.generators.ChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class BaseTerrainGen
extends GeneratorBase
implements ChunkGen {
    public BaseTerrainGen(DependencyInjector di) {
        super(di, "infinibiome:baseTerrain");
    }

    @Override
    public Timing getChunkGenTiming() {
        return ChunkGenTimings.BASE_TERRAIN;
    }

    @Override
    public void buildChunk(ChunkPos chunkPos, IChunk chunk) {
        MCHelper.forEachPos(chunkPos, p -> {
            this.placeStone((BlockPos2D)p, chunk);
            this.placeGroundBlocks((BlockPos2D)p, chunk);
            this.placeWaterIfNeeded((BlockPos2D)p, chunk);
        });
    }

    private void placeStone(BlockPos2D pos2D, IChunk world) {
        int maxHeight = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos2D);
        BlockPos.Mutable mutPos = new BlockPos.Mutable(pos2D.getBlockX(), 0, pos2D.getBlockZ());
        for (int blockY = 0; blockY <= maxHeight; ++blockY) {
            mutPos.func_185336_p(blockY);
            world.func_177436_a((BlockPos)mutPos, Blocks.field_150348_b.func_176223_P(), false);
        }
    }

    private void placeGroundBlocks(BlockPos2D pos, IChunk world) {
        List<BlockState> groundBlocks = this.posData.get(PosDataKeys.GROUND_BLOCKS, pos);
        int height = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos);
        for (int i = 0; i < groundBlocks.size(); ++i) {
            BlockPos pos3D = pos.to3D(height - i);
            world.func_177436_a(pos3D, groundBlocks.get(i), false);
        }
    }

    private void placeWaterIfNeeded(BlockPos2D pos2D, IChunk world) {
        int groundHeight = (int)this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos2D);
        BlockPos.Mutable mutPos = new BlockPos.Mutable(pos2D.getBlockX(), 0, pos2D.getBlockZ());
        for (int blockY = groundHeight + 1; blockY <= 63; ++blockY) {
            mutPos.func_185336_p(blockY);
            world.func_177436_a((BlockPos)mutPos, Blocks.field_150355_j.func_176223_P(), false);
        }
    }
}

