/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ChunkGen;
import weightedgpa.infinibiome.api.generators.ChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class BedrockGen
implements ChunkGen {
    private static final int HEIGHT = 6;
    private final RandomGen randomProducer;

    public BedrockGen(DependencyInjector di) {
        Seed seed = di.get(Seed.class).newSeed("infinibiome:bedrock");
        this.randomProducer = new RandomGen(seed);
    }

    @Override
    public Timing getChunkGenTiming() {
        return ChunkGenTimings.BEDROCK;
    }

    @Override
    public void buildChunk(ChunkPos chunkPos, IChunk chunk) {
        Random random = this.randomProducer.getRandom(chunkPos.field_77276_a, chunkPos.field_77275_b);
        MCHelper.forEachPos(chunkPos, pos -> {
            chunk.func_177436_a(pos.to3D(0), Blocks.field_150357_h.func_176223_P(), false);
            for (int y = 1; y <= 6; ++y) {
                if (random.nextInt(6) < y) continue;
                chunk.func_177436_a(pos.to3D(y), Blocks.field_150357_h.func_176223_P(), false);
            }
        });
    }
}

