/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks;

import java.util.BitSet;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ChunkGen;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.minecraftImpl.IBBiomes;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public abstract class CarverWrapper
extends GeneratorBase
implements ChunkGen {
    private final int sharedRandomSeed;

    protected CarverWrapper(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        this.sharedRandomSeed = this.seed.newSeed("sharedRandomSeed").getAsInt();
    }

    protected abstract GenerationStage.Carving getType();

    protected abstract ConfiguredCarver<?> getCarver();

    protected boolean passesExtraConditions(ChunkPos chunkPos) {
        return true;
    }

    @Override
    public final void buildChunk(ChunkPos chunkPos, IChunk chunk) {
        if (!this.passesExtraConditions(chunkPos)) {
            return;
        }
        BitSet bitset = chunk.func_205749_a(this.getType());
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        for (int xOffset = chunkPos.field_77276_a - 8; xOffset <= chunkPos.field_77276_a + 8; ++xOffset) {
            for (int zOffset = chunkPos.field_77275_b - 8; zOffset <= chunkPos.field_77275_b + 8; ++zOffset) {
                sharedSeedRandom.func_202425_c((long)this.sharedRandomSeed, xOffset, zOffset);
                if (!this.getCarver().func_222730_a((Random)sharedSeedRandom, xOffset, zOffset)) continue;
                this.getCarver().func_227207_a_(chunk, p -> IBBiomes.getBiome(MCHelper.to2D(p), this.posData), (Random)sharedSeedRandom, 63, xOffset, zOffset, chunkPos.field_77276_a, chunkPos.field_77275_b, bitset);
            }
        }
    }
}

