/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks.surface;

import java.util.function.Predicate;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.SimplexNoise;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.misc.Helper;

final class Patches {
    private final FloatFunc<BlockPos2D> layerCountFunc;
    private final FloatFunc<BlockPos2D> patchSizeFunc;
    private final PatchLayer[] layers;

    Patches(Seed seed) {
        seed = seed.newSeed("patches");
        this.layerCountFunc = Patches.initBaseLayerCount(seed);
        this.patchSizeFunc = Patches.initClusterSize(seed);
        this.layers = new PatchLayer[(int)this.layerCountFunc.getOutputInterval().getMax()];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new PatchLayer(seed.newSeed("patch " + i));
        }
    }

    private static FloatFunc<BlockPos2D> initBaseLayerCount(Seed seed) {
        seed = seed.newSeed("baseLayerCount");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(new Interval(1.0, 20.0));
    }

    private static FloatFunc<BlockPos2D> initClusterSize(Seed seed) {
        seed = seed.newSeed("clusterSize");
        return Helper.initUniformNoise(seed, 2048.0).mapInterval(new Interval(0.01f, 0.1f));
    }

    boolean canPlaceAt(BlockPos2D input, double extraProbability) {
        int layerCount = (int)(this.layerCountFunc.getOutput(input) * extraProbability);
        for (int i = 0; i < layerCount; ++i) {
            if (!this.layers[i].test(input)) continue;
            return true;
        }
        return false;
    }

    private class PatchLayer
    implements Predicate<BlockPos2D> {
        private static final double SCALE = 10.0;
        private final FloatFunc<BlockPos2D> base;

        PatchLayer(Seed seed) {
            seed = seed.newSeed("patchLayer");
            this.base = new SimplexNoise<BlockPos2D>(seed, 10.0, BlockPos2D.INFO).toUniform(SimplexNoise.PERCENTILE_TABLE);
        }

        @Override
        public boolean test(BlockPos2D input) {
            return this.base.getOutput(input) < Patches.this.patchSizeFunc.getOutput(input);
        }
    }
}

