/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks.surface;

import net.minecraft.block.Blocks;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.SurfaceTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.chunks.surface.SurfaceGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class PodzolSurfaceGen
extends SurfaceGenBase {
    private final Type type;

    public PodzolSurfaceGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:podzol" + type.name());
        this.type = type;
        this.config = this.initConfig().setBlock(Blocks.field_196661_l.func_176223_P()).setPatchy(type == Type.PATCHY).setSurfaceOnly().setSpawnsOnlyInDirt().setNeverUnderwater().neverInMushroomIsland().inSpawnRegion(type.spawnRegionRate).addExtraConditions(ConditionHelper.onlyInTreeDensity(di, new Interval(0.3f, 1.0)), new Condition[0]);
    }

    @Override
    public Timing getTiming() {
        return this.type.timing;
    }

    public String toString() {
        return "Podzol{type=" + (Object)((Object)this.type) + '}';
    }

    public static enum Type {
        FULL((double)0.025f, SurfaceTimings.FULL),
        PATCHY((double)0.05f, SurfaceTimings.PATCHY);

        private final double spawnRegionRate;
        private final Timing timing;

        private Type(double spawnRegionRate, Timing timing) {
            this.spawnRegionRate = spawnRegionRate;
            this.timing = timing;
        }
    }
}

