/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks.surface;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraftforge.common.Tags;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.SurfaceTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.internal.generators.chunks.surface.SurfaceGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class SandSurfaceGen
extends SurfaceGenBase {
    private static final List<Block> VALID_BLOCKS = new ArrayList<Block>();
    private final Type type;

    public SandSurfaceGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:sand" + type.name());
        this.type = type;
        this.config = this.initConfig().setBlock(type.block).setPatchy().setExtendsDown().setValidBlocks(VALID_BLOCKS).setNeverUnderwater().neverInMushroomIsland().inSpawnRegion(type.spawnRegionRate).addExtraConditions(ConditionHelper.onlyInHumidity(di, GenHelper.DRYISH), new Condition[0]);
    }

    @Override
    public Timing getTiming() {
        return SurfaceTimings.PATCHY;
    }

    public String toString() {
        return "Sand{type=" + (Object)((Object)this.type) + '}';
    }

    static {
        VALID_BLOCKS.addAll(Tags.Blocks.SAND.func_199885_a());
        VALID_BLOCKS.addAll(Tags.Blocks.DIRT.func_199885_a());
    }

    public static enum Type {
        SAND((double)0.025f, Blocks.field_150354_m.func_176223_P()),
        SAND_RED((double)0.0125f, Blocks.field_196611_F.func_176223_P()),
        SANDSTONE((double)0.0125f, Blocks.field_150322_A.func_176223_P()),
        SANDSTONE_RED((double)0.0125f, Blocks.field_180395_cM.func_176223_P());

        private final double spawnRegionRate;
        private final BlockState block;

        private Type(double spawnRegionRate, BlockState block) {
            this.spawnRegionRate = spawnRegionRate;
            this.block = block;
        }
    }
}

