/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks.surface;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.SurfaceGen;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.generators.chunks.surface.Patches;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public abstract class SurfaceGenBase
extends GeneratorBase
implements SurfaceGen,
Locatable.HasPointsProvider {
    protected Config config;
    private final Patches patches;

    SurfaceGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        this.patches = new Patches(this.seed);
    }

    @Override
    public void checkIsValid() {
        Validate.notNull(this.config);
    }

    @Override
    public void generate(BlockPos2D pos, IWorld world, Random random) {
        double probability = this.config.conditions.getAllProbability(pos, ConditionList.StrictOption.USE_LIKE_NON_STRICT);
        if (!MathHelper.randomBool(probability, random)) {
            return;
        }
        BlockPos groundPos = pos.to3D(MCHelper.getHighestTerrainHeight(pos, (IWorldReader)world));
        if (!this.validAboveGround(groundPos, (IBlockReader)world)) {
            return;
        }
        if (this.config.isPatchy && !this.patches.canPlaceAt(pos, probability)) {
            return;
        }
        this.placeSurface(groundPos, world);
    }

    private void placeSurface(BlockPos groundPos, IWorld world) {
        BlockPos placePos;
        for (int y = 0; y < 4 && (placePos = groundPos.func_177979_c(y)).func_177956_o() > 1 && this.isValidGround(placePos, (IBlockReader)world); ++y) {
            world.func_180501_a(placePos, this.config.block, 20);
            if (this.config.isSurfaceOnly) break;
        }
    }

    private boolean validAboveGround(BlockPos groundPos, IBlockReader world) {
        BlockState aboveGroundBlock = world.func_180495_p(groundPos.func_177984_a());
        boolean validUnderwater = this.config.isAlsoUnderwater && MCHelper.isMostlyWater(aboveGroundBlock);
        return MCHelper.isMostlyAir(aboveGroundBlock) || validUnderwater;
    }

    private boolean isValidGround(BlockPos pos, IBlockReader world) {
        return this.config.validBlock.contains(world.func_180495_p(pos).func_177230_c());
    }

    @Override
    public boolean isStackable() {
        return !MCHelper.isSolid(this.config.block);
    }

    public PointsProvider getAllLocations() {
        return new PredicateSearcher<BlockPos2D>(32, p -> this.config.conditions.canBeHere((BlockPos2D)p), BlockPos2D.INFO);
    }

    Config.BlockStep initConfig() {
        return new Config().new Config.BlockStep();
    }

    class Config {
        private BlockState block;
        private boolean isPatchy;
        private boolean isSurfaceOnly;
        private boolean isAlsoUnderwater;
        private Collection<Block> validBlock;
        private ConditionList conditions;

        private Config() {
            this.conditions = new ConditionList(ConditionHelper.onlyInLandMass(SurfaceGenBase.this.di, LandmassInfo::isLand), ConditionHelper.onlyWhereInfibiomeGenAllowed(SurfaceGenBase.this.di));
        }

        class ConditionStep {
            ConditionStep() {
            }

            Config addExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            Config noExtraConditions() {
                return Config.this;
            }
        }

        class RegionStep {
            RegionStep() {
            }

            ConditionStep inSpawnRegion(double rate) {
                Validate.isTrue(rate > 0.0);
                double fade = !Config.this.isPatchy ? 0.25 : 0.5;
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInRegion(SurfaceGenBase.this.seed, rate, fade));
                return new ConditionStep();
            }

            ConditionStep noSpawnRegion() {
                return new ConditionStep();
            }
        }

        class MushroomIslandStep {
            MushroomIslandStep() {
            }

            RegionStep neverInMushroomIsland() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInMushroomIsland(SurfaceGenBase.this.di).invert());
                return new RegionStep();
            }

            RegionStep onlyInMushroomIsland() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInMushroomIsland(SurfaceGenBase.this.di));
                return new RegionStep();
            }
        }

        class ValidAboveBlockStep {
            ValidAboveBlockStep() {
            }

            MushroomIslandStep setNeverUnderwater() {
                Config.this.isAlsoUnderwater = false;
                return new MushroomIslandStep();
            }

            MushroomIslandStep setAlsoUnderwater() {
                Config.this.isAlsoUnderwater = true;
                return new MushroomIslandStep();
            }
        }

        class ValidReplacementStep {
            ValidReplacementStep() {
            }

            ValidAboveBlockStep setSpawnsOnlyInDirt() {
                Config.this.validBlock = Lists.newArrayList((Object[])new Block[]{Blocks.field_150346_d});
                return new ValidAboveBlockStep();
            }

            ValidAboveBlockStep setSpawnsOnlyInSand() {
                Config.this.validBlock = Lists.newArrayList((Object[])new Block[]{Blocks.field_150354_m});
                return new ValidAboveBlockStep();
            }

            ValidAboveBlockStep setSpawnsOnlyInDirtAndSand() {
                Config.this.validBlock = Lists.newArrayList((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_150354_m});
                return new ValidAboveBlockStep();
            }

            ValidAboveBlockStep setValidBlocks(Collection<Block> validBlocks) {
                Config.this.validBlock = new ArrayList<Block>(validBlocks);
                return new ValidAboveBlockStep();
            }
        }

        class DepthStep {
            DepthStep() {
            }

            ValidReplacementStep setSurfaceOnly() {
                Config.this.isSurfaceOnly = true;
                return new ValidReplacementStep();
            }

            ValidReplacementStep setExtendsDown() {
                Config.this.isSurfaceOnly = false;
                return new ValidReplacementStep();
            }
        }

        class IsPatchyStep {
            IsPatchyStep() {
            }

            DepthStep setFull() {
                return this.setPatchy(false);
            }

            DepthStep setPatchy() {
                return this.setPatchy(true);
            }

            DepthStep setPatchy(boolean isPatchy) {
                Config.this.isPatchy = isPatchy;
                return new DepthStep();
            }
        }

        class BlockStep {
            BlockStep() {
            }

            IsPatchyStep setBlock(BlockState block) {
                Config.this.block = block;
                return new IsPatchyStep();
            }
        }
    }
}

