/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.chunks.surface;

import java.util.Comparator;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.IChunk;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.ChunkGen;
import weightedgpa.infinibiome.api.generators.ChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.generators.SurfaceGen;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.generators.utils.SortedRandomizedList;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeDetectingWorld;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChunkAsWorld;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class SurfaceGens
implements ChunkGen {
    private final SortedRandomizedList<SurfaceGen> surfaceGens;
    private final RandomGen randomGen;

    public SurfaceGens(DependencyInjector di) {
        this.surfaceGens = new SortedRandomizedList<SurfaceGen>(di.getAll(SurfaceGen.class), Comparator.comparing(SurfaceGen::getTiming));
        this.randomGen = new RandomGen(di.get(Seed.class).newSeed("surfaceGens"));
    }

    @Override
    public Timing getChunkGenTiming() {
        return ChunkGenTimings.SURFACE;
    }

    @Override
    public void buildChunk(ChunkPos chunkPos, IChunk chunk) {
        MCHelper.forEachPos(chunkPos, p -> {
            ChangeDetectingWorld worldWrapper = new ChangeDetectingWorld(new ChunkAsWorld(chunk));
            Random random = this.randomGen.getRandom(p.getBlockX(), p.getBlockZ());
            this.surfaceGens.forEachItem(surfaceGen -> {
                surfaceGen.generate((BlockPos2D)p, worldWrapper, random);
                if (surfaceGen.isStackable()) {
                    return true;
                }
                return !worldWrapper.anyChange();
            });
        });
    }
}

