/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class BeehiveGen
extends GeneratorBase
implements InterChunkGen {
    public BeehiveGen(DependencyInjector di) {
        super(di, "infinibiome:beeHive");
        DebugCommand.registerDebugFunc("flower", "density", p -> {
            double result = 0.0;
            for (Block flower : BlockTags.field_226149_I_.func_199885_a()) {
                result += MCHelper.getPlantDensity(new InterChunkPos((BlockPos2D)p), (IWorldReader)di.get(ServerWorld.class), (IPlantable)flower, () -> 0.0);
            }
            return String.valueOf(result);
        });
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.BEEHIVE;
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        List<HiveInfo> validPos = this.getValidHivePos(interChunkPos, interChunks, random);
        int count = Math.min(validPos.size(), this.getCount(interChunkPos, interChunks, random));
        for (int i = 0; i < count; ++i) {
            this.generateHive(validPos.get(i), interChunks, random);
        }
    }

    private int getCount(InterChunkPos interChunkPos, IWorld world, Random random) {
        double avgCount = 0.0;
        for (Block flower : BlockTags.field_226149_I_.func_199885_a()) {
            avgCount += MCHelper.getPlantDensity(interChunkPos, (IWorldReader)world, (IPlantable)flower, () -> 0.0);
        }
        return MathHelper.randomRound(avgCount *= 0.125, random);
    }

    private boolean isTooColdOrDry(BlockPos2D pos) {
        double temp = PosDataHelper.getTemperature(pos, this.posData);
        if (PosDataHelper.FREEZE_INTERVAL.contains(temp)) {
            return true;
        }
        double humd = PosDataHelper.getHumidity(pos, this.posData);
        return PosDataHelper.DRY_INTERVAL.contains(humd);
    }

    private List<HiveInfo> getValidHivePos(InterChunkPos interChunkPos, IWorld world, Random random) {
        ArrayList<HiveInfo> result = new ArrayList<HiveInfo>();
        result.addAll(new TreeType().getAllValidHivePos(interChunkPos, world, random));
        result.addAll(new GroundType().getAllValidHivePos(interChunkPos, world, random));
        result.removeIf(p -> PosDataHelper.FREEZE_INTERVAL.contains(PosDataHelper.getTemperature(p.pos, this.posData)));
        return result;
    }

    private void generateHive(HiveInfo hiveInfo, IWorld world, Random random) {
        BlockPos hivePos = hiveInfo.pos;
        Direction hiveDirection = hiveInfo.direction;
        this.placeHiveBlock(hivePos, hiveDirection, world);
        this.placeBeeEntity(hivePos, world, random);
        hiveInfo.extraStepFunc.run(hivePos, hiveDirection, world, random);
    }

    private void placeHiveBlock(BlockPos hivePos, Direction hiveDirection, IWorld world) {
        world.func_180501_a(hivePos, this.getHiveBlock(hiveDirection), 20);
    }

    private void placeBeeEntity(BlockPos hivePos, IWorld world, Random random) {
        TileEntity tileEntity = world.func_175625_s(hivePos);
        if (tileEntity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehivetileentity = (BeehiveTileEntity)tileEntity;
            int j = 2 + random.nextInt(2);
            for (int k = 0; k < j; ++k) {
                BeeEntity beeentity = new BeeEntity(EntityType.field_226289_e_, world.func_201672_e());
                beehivetileentity.func_226962_a_((Entity)beeentity, false, random.nextInt(599));
            }
        }
    }

    private BlockState getHiveBlock(Direction direction) {
        return (BlockState)((BlockState)Blocks.field_226905_ma_.func_176223_P().func_206870_a((IProperty)BeehiveBlock.field_226872_b_, (Comparable)direction)).func_206870_a((IProperty)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(5));
    }

    private static class HiveInfo {
        final BlockPos pos;
        final Direction direction;
        final ExtraStepFunc extraStepFunc;

        HiveInfo(BlockPos pos, Direction direction, ExtraStepFunc extraStepFunc) {
            this.pos = pos;
            this.direction = direction;
            this.extraStepFunc = extraStepFunc;
        }

        public String toString() {
            return "HiveInfo{pos=" + this.pos + ", direction=" + this.direction + '}';
        }

        @FunctionalInterface
        static interface ExtraStepFunc {
            public static final ExtraStepFunc DO_NOTHING = (pos, direction, world, random) -> {};

            public void run(BlockPos var1, Direction var2, IWorld var3, Random var4);
        }
    }

    private class GroundType {
        private GroundType() {
        }

        private List<HiveInfo> getAllValidHivePos(InterChunkPos interChunkPos, IWorld world, Random random) {
            ArrayList<HiveInfo> result = new ArrayList<HiveInfo>();
            interChunkPos.forEachCenterPos(p -> {
                if (BeehiveGen.this.isTooColdOrDry(p)) {
                    return;
                }
                int centerHeight = MCHelper.getHighestTerrainHeight(p, (IWorldReader)world);
                if (centerHeight < 63) {
                    return;
                }
                Direction tunnelDirection = this.getCornerDirection((BlockPos2D)p, world, random);
                if (tunnelDirection == null) {
                    return;
                }
                if (!this.isValidTunnel(p.to3D(centerHeight), tunnelDirection, world)) {
                    return;
                }
                result.add(new HiveInfo(p.to3D(centerHeight).func_177967_a(tunnelDirection, 2), tunnelDirection.func_176734_d(), this::extraStep));
            });
            Collections.shuffle(result);
            return result;
        }

        void extraStep(BlockPos hivePos, Direction hiveDirection, IWorld world, Random random) {
            world.func_217377_a(hivePos.func_177972_a(hiveDirection), false);
            world.func_217377_a(hivePos.func_177967_a(hiveDirection, 2), false);
            MCHelper.clearVertically(hivePos, world, b -> MCHelper.isSolid(b) || b.func_177230_c().equals(Blocks.field_150433_aE));
        }

        @Nullable
        Direction getCornerDirection(BlockPos2D centerPos, IWorld world, Random random) {
            ArrayList<Direction> shuffledDirection = new ArrayList<Direction>(MCHelper.NSWE);
            Collections.shuffle(shuffledDirection, random);
            for (Direction d : shuffledDirection) {
                if (!this.isCorner(centerPos, d, world)) continue;
                return d;
            }
            return null;
        }

        boolean isCorner(BlockPos2D centerPos, Direction direction, IWorld world) {
            int center = MCHelper.getHighestTerrainHeight(centerPos, (IWorldReader)world);
            int corner1 = MCHelper.getHighestTerrainHeight(centerPos.offset(direction), (IWorldReader)world);
            int corner2 = MCHelper.getHighestTerrainHeight(centerPos.offset(direction.func_176746_e()), (IWorldReader)world);
            int oppositeCorner1 = MCHelper.getHighestTerrainHeight(centerPos.offset(direction.func_176734_d()), (IWorldReader)world);
            int oppositeCorner2 = MCHelper.getHighestTerrainHeight(centerPos.offset(direction.func_176746_e().func_176734_d()), (IWorldReader)world);
            if (corner1 != center + 1) {
                return false;
            }
            if (corner2 != center + 1) {
                return false;
            }
            if (oppositeCorner1 != center) {
                return false;
            }
            return oppositeCorner2 == center;
        }

        boolean isValidTunnel(BlockPos centerPos, Direction tunnelDirection, IWorld world) {
            for (int i = 0; i <= 2; ++i) {
                BlockPos tunnelPos = centerPos.func_177967_a(tunnelDirection, i);
                if (!this.isValidSolid(tunnelPos, tunnelDirection.func_176746_e(), world)) {
                    return false;
                }
                if (!this.isValidSolid(tunnelPos, tunnelDirection.func_176746_e().func_176734_d(), world)) {
                    return false;
                }
                if (!(i == 0 ? !MCHelper.isMostlyAir(this.getBlock(centerPos, Direction.UP, world)) : !this.isValidSolid(tunnelPos, Direction.UP, world))) continue;
                return false;
            }
            return true;
        }

        boolean isValidSolid(BlockPos centerPos, Direction direction, IWorld world) {
            return this.isValidSolid(this.getBlock(centerPos, direction, world));
        }

        boolean isValidSolid(BlockState block) {
            if (!MCHelper.isSolid(block)) {
                return false;
            }
            if (Tags.Blocks.SAND.func_199685_a_((Object)block.func_177230_c())) {
                return false;
            }
            if (Tags.Blocks.GRAVEL.func_199685_a_((Object)block.func_177230_c())) {
                return false;
            }
            if (Tags.Blocks.STONE.func_199685_a_((Object)block.func_177230_c())) {
                return false;
            }
            return !Tags.Blocks.SANDSTONE.func_199685_a_((Object)block.func_177230_c());
        }

        BlockState getBlock(BlockPos pos, Direction d, IWorld world) {
            return world.func_180495_p(pos.func_177972_a(d));
        }
    }

    private class TreeType {
        private TreeType() {
        }

        private List<HiveInfo> getAllValidHivePos(InterChunkPos interChunkPos, IWorld world, Random random) {
            ArrayList<HiveInfo> result = new ArrayList<HiveInfo>();
            interChunkPos.forEachCenterPos(p -> {
                if (BeehiveGen.this.isTooColdOrDry(p)) {
                    return;
                }
                if (!this.insideTree((BlockPos2D)p, (IWorldReader)world)) {
                    return;
                }
                Direction hiveDirection = this.getBeeHiveDirection(random);
                BlockPos2D hivePos2D = p.offset(hiveDirection);
                Integer hiveHeight = this.getHiveHeight(hivePos2D, world);
                if (hiveHeight == null) {
                    return;
                }
                BlockPos hivePos = hivePos2D.to3D(hiveHeight);
                result.add(new HiveInfo(hivePos, hiveDirection, HiveInfo.ExtraStepFunc.DO_NOTHING));
            });
            Collections.shuffle(result);
            return result;
        }

        boolean insideTree(BlockPos2D pos, IWorldReader world) {
            int trunkHeight = MCHelper.getHighestTerrainHeight(pos, world) + 1;
            BlockPos trunkPos = pos.to3D(trunkHeight);
            BlockState trunkBlock = world.func_180495_p(trunkPos);
            return trunkBlock.func_203425_a(BlockTags.field_200031_h);
        }

        Direction getBeeHiveDirection(Random random) {
            int randomIndex = random.nextInt(MCHelper.NSWE.size());
            return MCHelper.NSWE.get(randomIndex);
        }

        @Nullable
        Integer getHiveHeight(BlockPos2D hivePos, IWorld world) {
            int groundHeight;
            for (int y = groundHeight = MCHelper.getHighestTerrainHeight(hivePos, (IWorldReader)world); y < groundHeight + 10; ++y) {
                BlockState scannedBlock = world.func_180495_p(hivePos.to3D(y));
                if (!scannedBlock.func_203425_a(BlockTags.field_206952_E) && !scannedBlock.func_203425_a(BlockTags.field_200031_h)) continue;
                int hiveHeight = y - 1;
                if (hiveHeight - groundHeight < 2) {
                    return null;
                }
                return hiveHeight;
            }
            return null;
        }
    }
}

