/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Comparator;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.SingleDep;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.generators.utils.SortedRandomizedList;
import weightedgpa.infinibiome.internal.minecraftImpl.world.NoClientUpdatingWorld;
import weightedgpa.infinibiome.internal.misc.DeadlockDetector;

public final class InterChunkGens
implements SingleDep {
    private final SortedRandomizedList<InterChunkGen> interChunkGens;
    private final DeadlockDetector deadlockDetector = new DeadlockDetector();

    public InterChunkGens(DependencyInjector di) {
        this.interChunkGens = new SortedRandomizedList<InterChunkGen>(di.getAll(InterChunkGen.class), Comparator.comparing(InterChunkGen::getInterChunkTiming));
    }

    public void generateAll(InterChunkPos interChunkPos, IWorld world) {
        IWorld finalWorld = world = new NoClientUpdatingWorld(world);
        this.interChunkGens.forEachItem(resourceGen -> {
            this.perInterChunkGen((InterChunkGen)resourceGen, interChunkPos, finalWorld);
            return true;
        });
    }

    private void perInterChunkGen(InterChunkGen interChunkGen, InterChunkPos pos, IWorld world) {
        try {
            this.deadlockDetector.setCurrentRunningGenerator(interChunkGen);
            interChunkGen.generate(pos, world);
            this.deadlockDetector.currentGeneratorFinished();
        }
        catch (Throwable e) {
            throw new RuntimeException(interChunkGen.toString(), e);
        }
    }
}

