/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.internal.generators.interchunks.SmallObjectGenBase;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class LiquidOre
extends SmallObjectGenBase {
    private final Type type;

    public LiquidOre(Type type, DependencyInjector di) {
        super(di, "infinibiome:liquidOre" + type.name());
        this.type = type;
        this.config = this.initConfig().getGenerateFunc(this::generate).setCount(type.frequency).setAttemptsPerCount(1).randomBetweenHeight(0, type.maxHeight).noChancePerChunk().noExtraConditions();
    }

    private void generate(BlockPos pos, IWorld world, Random random) {
        if (!world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150348_b)) {
            return;
        }
        if (!this.nextToOneAir(pos, (IWorldReader)world)) {
            return;
        }
        if (this.nextToLiquid(pos, (IWorldReader)world)) {
            return;
        }
        if (!world.func_180495_p(pos.func_177984_a()).func_177230_c().equals(Blocks.field_150348_b)) {
            return;
        }
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().equals(Blocks.field_150348_b)) {
            return;
        }
        world.func_180501_a(pos, this.type.block, 20);
        world.func_205219_F_().func_205360_a(pos, (Object)this.type.block.func_204520_s().func_206886_c(), 0);
    }

    private boolean nextToOneAir(BlockPos pos, IWorldReader world) {
        int count = 0;
        for (Direction d : MCHelper.NSWE) {
            if (!world.func_180495_p(pos.func_177972_a(d)).func_196958_f()) continue;
            ++count;
        }
        return count == 1;
    }

    private boolean nextToLiquid(BlockPos pos, IWorldReader world) {
        for (Direction d : Direction.values()) {
            if (!world.func_180495_p(pos.func_177972_a(d)).func_185904_a().func_76224_d()) continue;
            return true;
        }
        return false;
    }

    public static enum Type {
        WATER(Blocks.field_150355_j.func_176223_P(), 32.0, 128),
        LAVA(Blocks.field_150353_l.func_176223_P(), 4.0, 63);

        private final BlockState block;
        private final double frequency;
        private final int maxHeight;

        private Type(BlockState block, double frequency, int maxHeight) {
            this.block = block;
            this.frequency = frequency;
            this.maxHeight = maxHeight;
        }
    }
}

