/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ChangeDetectingWorld;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public abstract class SmallObjectGenBase
extends GeneratorBase
implements InterChunkGen {
    public Config config;

    protected SmallObjectGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        DebugCommand.registerDebugFunc(seedBranch, "count", p -> this.config.countFunc.getOutput(p));
        DebugCommand.registerDebugFunc(seedBranch, "actualCount", p -> this.getActualCount(new InterChunkPos((BlockPos2D)p)));
        DebugCommand.registerDebugFunc(seedBranch, "conditions", p -> this.config.conditions._debug((BlockPos2D)p));
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.STRUCTS;
    }

    @Override
    public final void generate(InterChunkPos interChunkPos, IWorld world) {
        int count = this.getActualCount(interChunkPos);
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        block0: for (int i = 0; i < count; ++i) {
            BlockPos2D randomPos;
            for (int j = 0; j < this.config.maxAttempts && this.canGenerateHere(randomPos = interChunkPos.getRandomCenterPos(random), random); ++j) {
                int height = this.config.getHeightFunc.getHeight(randomPos, world, random);
                ChangeDetectingWorld worldWrapper = new ChangeDetectingWorld(world);
                this.config.generateObjectFunc.run(randomPos.to3D(height), worldWrapper, random);
                if (worldWrapper.anyChange()) continue block0;
            }
        }
    }

    private boolean canGenerateHere(BlockPos2D pos, Random random) {
        double specificProbability = this.config.conditions.getAllProbability(pos, ConditionList.StrictOption.ONLY);
        return MathHelper.randomBool(specificProbability, random);
    }

    private int getActualCount(InterChunkPos interChunkPos) {
        double avgCount = 1.0;
        avgCount *= this.config.countFunc.getOutput(interChunkPos.getLowestCenterBlockPos());
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        return MathHelper.randomRound(avgCount *= this.config.conditions.getAllProbability(interChunkPos, ConditionList.StrictOption.EXCLUDE), random);
    }

    protected final Config.GenStep initConfig() {
        return new Config().new Config.GenStep();
    }

    @Override
    public void checkIsValid() {
        Validate.notNull(this.config);
    }

    public PointsProvider<BlockPos2D> getAllLocations() {
        return new PredicateSearcher<InterChunkPos>(1, p -> this.getActualCount((InterChunkPos)p) > 0 && this.config.conditions.canBeHere((InterChunkPos)p), InterChunkPos.INFO).mapPoints(BlockPos2D.INFO);
    }

    protected class Config {
        private GenerateObjectFunc generateObjectFunc;
        private FloatFunc<BlockPos2D> countFunc;
        private int maxAttempts;
        private GetHeightFunc getHeightFunc;
        public ConditionList conditions;

        private Config() {
            this.conditions = new ConditionList(ConditionHelper.onlyWhereInfibiomeGenAllowed(SmallObjectGenBase.this.di));
        }

        public class ConditionStep {
            public Config addExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            public Config noExtraConditions() {
                return Config.this;
            }
        }

        public class ChanceStep {
            public ConditionStep noChancePerChunk() {
                return new ConditionStep();
            }

            public ConditionStep setChancePerChunk(double chance) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.chancePerChunk(chance));
                return new ConditionStep();
            }

            public ConditionStep onlyInRegion(double rate) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInRegion(SmallObjectGenBase.this.seed, rate));
                return new ConditionStep();
            }
        }

        public class HeightStep {
            public ChanceStep aboveHighestTerrainBlock() {
                return this.customHeightFunc((p, w, r) -> MCHelper.getHighestTerrainHeight(p, (IWorldReader)w) + 1);
            }

            public ChanceStep atHighestTerrainBlock() {
                return this.customHeightFunc((p, w, r) -> MCHelper.getHighestTerrainHeight(p, (IWorldReader)w));
            }

            public ChanceStep randomUnderHeight(int max) {
                return this.randomBetweenHeight(0, max);
            }

            public ChanceStep randomBetweenHeight(int min, int max) {
                return this.customHeightFunc((p, w, r) -> MathHelper.randomInt(min, max, r));
            }

            public ChanceStep customHeightFunc(GetHeightFunc getHeight) {
                Config.this.getHeightFunc = getHeight;
                return new ChanceStep();
            }
        }

        public class AttemptsStep {
            public HeightStep setAttemptsPerCount(int attempts) {
                Config.this.maxAttempts = attempts;
                return new HeightStep();
            }
        }

        public class CountStep {
            public AttemptsStep setCount(FloatFunc<BlockPos2D> count) {
                Validate.isTrue(Interval.NON_NEGATIVES.containsAll(count.getOutputInterval()));
                Config.this.countFunc = count;
                return new AttemptsStep();
            }

            public AttemptsStep setCount(double count) {
                return this.setCount(FloatFunc.constFunc(count));
            }
        }

        public class GenStep {
            public CountStep getGenerateFunc(GenerateObjectFunc func) {
                Config.this.generateObjectFunc = func;
                return new CountStep();
            }

            public CountStep setWithFeature(ConfiguredFeature<?, ?> feature) {
                return this.getGenerateFunc((pos, world, random) -> feature.func_222734_a(world, SmallObjectGenBase.this.chunkGenerator, random, pos));
            }

            public CountStep setWithFeature(Feature<NoFeatureConfig> feature) {
                return this.setWithFeature(feature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }

            public <I extends IFeatureConfig> CountStep setWithFeature(Feature<I> feature, I config) {
                return this.setWithFeature(feature.func_225566_b_(config));
            }
        }
    }

    @FunctionalInterface
    protected static interface GetHeightFunc {
        public int getHeight(BlockPos2D var1, IWorld var2, Random var3);
    }

    @FunctionalInterface
    static interface GenerateObjectFunc {
        public void run(BlockPos var1, IWorld var2, Random var3);
    }
}

