/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.ClimateValue;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.minecraftImpl.IBBiomes;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class SnowGen
implements InterChunkGen {
    private final PosDataProvider posData;

    public SnowGen(DependencyInjector di) {
        this.posData = di.get(PosDataProvider.class);
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.SNOW;
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        interChunkPos.forEachAllPos(p -> {
            if (!this.couldSnowAtAnyHeight((BlockPos2D)p)) {
                return;
            }
            BlockPos snowPos = p.to3D(MCHelper.getHighestY(p, (IWorldReader)interChunks, b -> !b.func_177230_c().equals(Blocks.field_150433_aE)) + 1);
            this.removeCoveredSnow(snowPos, interChunks);
            this.tryPlaceSnow(snowPos, interChunks);
        });
    }

    private boolean couldSnowAtAnyHeight(BlockPos2D pos) {
        ClimateValue temp = this.posData.get(PosDataKeys.TEMPERATURE, pos);
        if (PosDataHelper.FREEZE_INTERVAL.contains(temp.fromHeight(0.0))) {
            return true;
        }
        return PosDataHelper.FREEZE_INTERVAL.contains(temp.fromHeight(255.0));
    }

    private void tryPlaceSnow(BlockPos snowPos, IWorld world) {
        Biome biome = IBBiomes.getBiome(MCHelper.to2D(snowPos), this.posData);
        if (biome.func_201850_b((IWorldReader)world, snowPos)) {
            world.func_180501_a(snowPos, Blocks.field_150433_aE.func_176223_P(), 20);
            BlockState snowyDirt = world.func_180495_p(snowPos.func_177977_b());
            if (snowyDirt.func_196959_b((IProperty)SnowyDirtBlock.field_196382_a)) {
                world.func_180501_a(snowPos.func_177977_b(), (BlockState)snowyDirt.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 20);
            }
        } else if (biome.func_201848_a((IWorldReader)world, snowPos.func_177977_b())) {
            world.func_180501_a(snowPos.func_177977_b(), Blocks.field_150432_aD.func_176223_P(), 20);
        }
    }

    private void removeCoveredSnow(BlockPos snowPos, IWorld world) {
        int maxY = snowPos.func_177956_o() - 1;
        int minY = MCHelper.getHighestTerrainHeight(MCHelper.to2D(snowPos), (IWorldReader)world);
        boolean inOcean = this.posData.get(PosDataKeys.LANDMASS_TYPE, MCHelper.to2D(snowPos)).isOcean();
        BlockPos.Mutable mutPos = new BlockPos.Mutable(snowPos);
        for (int y = maxY; y >= minY; --y) {
            mutPos.func_185336_p(y);
            if (this.tryUnfreeze((BlockPos)mutPos, world, inOcean)) break;
        }
    }

    private boolean tryUnfreeze(BlockPos snowPos, IWorld world, boolean inOcean) {
        BlockState snowBlock = world.func_180495_p(snowPos);
        BlockPos iceOrDirtPos = snowPos.func_177977_b();
        BlockState iceOrDirt = world.func_180495_p(iceOrDirtPos);
        if (snowBlock.func_177230_c().equals(Blocks.field_150433_aE)) {
            world.func_180501_a(snowPos, Blocks.field_150350_a.func_176223_P(), 20);
            if (iceOrDirt.func_196959_b((IProperty)SnowyDirtBlock.field_196382_a) && ((Boolean)iceOrDirt.func_177229_b((IProperty)SnowyDirtBlock.field_196382_a)).booleanValue()) {
                world.func_180501_a(iceOrDirtPos, (BlockState)iceOrDirt.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(false)), 20);
            }
            return true;
        }
        boolean underneathSolid = MCHelper.isSolid(world.func_180495_p(iceOrDirtPos.func_177984_a()));
        if (!underneathSolid && !inOcean && iceOrDirt.func_177230_c().equals(Blocks.field_150432_aD)) {
            world.func_180501_a(iceOrDirtPos, Blocks.field_150355_j.func_176223_P(), 20);
            return true;
        }
        return false;
    }
}

