/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.api.posdata.PosDataProvider;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

final class SurfacePool {
    private static final int MIN_CLEAR_HEIGHT = 3;
    private static final int MAX_CLEAR_HEIGHT = 4;
    final BlockPos2D center;
    final int liquidY;
    final int clearHeight;
    final Config config;
    private final Map<BlockPos2D, BlockState> blockLayout = new HashMap<BlockPos2D, BlockState>();
    private final PosDataProvider data;

    private SurfacePool(BlockPos2D center, IWorldReader world, PosDataProvider data, Random random, Config config) {
        this.config = config;
        this.center = center;
        this.data = data;
        this.initBlockLayout(world, random);
        this.liquidY = this.getLiquidY();
        this.clearHeight = MathHelper.randomInt(3, 4, random);
    }

    static boolean tryGeneratePoolAt(BlockPos2D center, Config poolConfig, IWorld world, PosDataProvider data, Random random) {
        return new SurfacePool(center, (IWorldReader)world, data, random, poolConfig).generate(world, random);
    }

    Collection<BlockPos2D> iteratePoolAndEdge(int edgeDistance) {
        if (edgeDistance == 0) {
            return this.blockLayout.keySet();
        }
        HashSet<BlockPos2D> out = new HashSet<BlockPos2D>(this.blockLayout.keySet());
        for (BlockPos2D pos : this.blockLayout.keySet()) {
            for (int x = -edgeDistance; x <= edgeDistance; ++x) {
                for (int z = -edgeDistance; z <= edgeDistance; ++z) {
                    BlockPos2D scanPos = pos.offset(x, z);
                    if (out.contains(scanPos)) continue;
                    out.add(scanPos);
                }
            }
        }
        return out;
    }

    private void initBlockLayout(IWorldReader world, Random random) {
        int maxRadius = (int)Math.ceil(this.config.innerRadiusFunc.getOutputInterval().getMax() + this.config.outerRadiusFunc.getOutputInterval().getMax());
        for (int x = -maxRadius; x <= maxRadius; ++x) {
            for (int z = -maxRadius; z <= maxRadius; ++z) {
                BlockPos2D currentPos = this.center.offset(x, z);
                double innerRadius = this.config.innerRadiusFunc.getOutput(currentPos);
                double outerRadius = this.config.outerRadiusFunc.getOutput(currentPos);
                double distanceFromCenterSq = MathHelper.getDistanceSq(BlockPos2D.INFO, this.center, currentPos);
                if (distanceFromCenterSq < Math.pow(innerRadius, 2.0)) {
                    this.blockLayout.put(currentPos, this.config.innerBlocksFunc.getBlock(currentPos.to3D(this.liquidY), world, random));
                    continue;
                }
                if (!(distanceFromCenterSq < Math.pow(innerRadius + outerRadius, 2.0))) continue;
                this.blockLayout.put(currentPos, this.config.outerBlocksFunc.getBlock(currentPos.to3D(this.liquidY), world, random));
            }
        }
    }

    private int getLiquidY() {
        return this.iteratePoolAndEdge(0).stream().mapToInt(v -> (int)this.data.get(PosDataKeys.MAPPED_HEIGHT, (BlockPos2D)v)).min().getAsInt();
    }

    private boolean generate(IWorld world, Random random) {
        if (!this.config.extraConditions.passes(this, (IWorldReader)world, random)) {
            return false;
        }
        if (!this.floorIsValid((IWorldReader)world)) {
            return false;
        }
        if (!this.ceilIsValid((IWorldReader)world)) {
            return false;
        }
        if (this.liquidNearby((IWorldReader)world)) {
            return false;
        }
        this.clearPlantsAbovePool(world);
        this.placePool(world);
        this.config.extraSteps.run(this, world, random);
        return true;
    }

    private boolean floorIsValid(IWorldReader world) {
        for (BlockPos2D floorPos2D : this.iteratePoolAndEdge(0)) {
            BlockPos floorPos = floorPos2D.to3D(this.liquidY - 1);
            if (MCHelper.isSolid(world.func_180495_p(floorPos))) continue;
            return false;
        }
        return true;
    }

    private boolean ceilIsValid(IWorldReader world) {
        for (BlockPos2D currPos2D : this.iteratePoolAndEdge(0)) {
            int mappedHeight = MCHelper.getHighestTerrainHeight(currPos2D, world);
            if (mappedHeight > this.liquidY + this.clearHeight) continue;
            BlockState blockAtSurface = world.func_180495_p(currPos2D.to3D(mappedHeight));
            BlockState blockAboveSurface = world.func_180495_p(currPos2D.to3D(mappedHeight + 1));
            if (blockAtSurface.func_177230_c().equals(Blocks.field_185774_da)) {
                return false;
            }
            if (blockAboveSurface.func_196958_f() || MCHelper.isPlant(blockAboveSurface.func_177230_c()) || blockAboveSurface.func_177230_c().equals(Blocks.field_150433_aE)) continue;
            return false;
        }
        return true;
    }

    private boolean liquidNearby(IWorldReader world) {
        for (int y = this.liquidY - 1; y <= this.liquidY + this.clearHeight + 1; ++y) {
            for (BlockPos2D currPos2D : this.iteratePoolAndEdge(1)) {
                BlockPos currPos = currPos2D.to3D(y);
                if (!world.func_180495_p(currPos).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    private void placePool(IWorld world) {
        for (Map.Entry<BlockPos2D, BlockState> entry : this.blockLayout.entrySet()) {
            BlockPos2D pos2D = entry.getKey();
            BlockState block = entry.getValue();
            world.func_180501_a(pos2D.to3D(this.liquidY), block, 20);
            for (int y = this.liquidY + 1; y <= this.liquidY + this.clearHeight; ++y) {
                world.func_180501_a(pos2D.to3D(y), Blocks.field_150350_a.func_176223_P(), 20);
            }
        }
    }

    private void clearPlantsAbovePool(IWorld world) {
        for (BlockPos2D pos : this.iteratePoolAndEdge(0)) {
            MCHelper.clearVertically(pos.to3D(this.liquidY), world, b -> MCHelper.isPlant(b.func_177230_c()) || b.func_177230_c().equals(Blocks.field_150433_aE));
        }
    }

    static class Config {
        private final FloatFunc<BlockPos2D> innerRadiusFunc;
        private final FloatFunc<BlockPos2D> outerRadiusFunc;
        private final GetBlockFunc innerBlocksFunc;
        private final GetBlockFunc outerBlocksFunc;
        private final ExtraCondition extraConditions;
        private final ExtraStep extraSteps;

        Config(FloatFunc<BlockPos2D> innerRadiusFunc, FloatFunc<BlockPos2D> outerRadiusFunc, GetBlockFunc innerBlocksFunc, GetBlockFunc outerBlocksFunc, ExtraCondition extraConditions, ExtraStep extraSteps) {
            this.innerRadiusFunc = innerRadiusFunc;
            this.outerRadiusFunc = outerRadiusFunc;
            this.innerBlocksFunc = innerBlocksFunc;
            this.outerBlocksFunc = outerBlocksFunc;
            this.extraConditions = extraConditions;
            this.extraSteps = extraSteps;
        }

        @FunctionalInterface
        static interface ExtraStep {
            public void run(SurfacePool var1, IWorld var2, Random var3);
        }

        @FunctionalInterface
        static interface ExtraCondition {
            public boolean passes(SurfacePool var1, IWorldReader var2, Random var3);
        }

        @FunctionalInterface
        static interface GetBlockFunc {
            public BlockState getBlock(BlockPos var1, IWorldReader var2, Random var3);
        }
    }
}

