/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.IntervalMapperWrapper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.SurfacePool;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class SurfacePoolLavaGen
extends GeneratorBase
implements InterChunkGen {
    private static final int LAVA_BURN_RADIUS = 3;
    private static final double INIT_ROCKY_CHANCE = 0.25;
    private static final double ROCKY_CHANCE_CHANGE_PER_Y = (double)-0.025f;
    private static final double GRAVEL_CHANCE = 0.25;
    private static final double MAX_CHANCE_PER_CHUNK = (double)0.05f;
    private final FloatFunc<BlockPos2D> chancePerChunkFunc;
    private final FloatFunc<BlockPos2D> lavaRadiusFunc;
    private final FloatFunc<BlockPos2D> stoneRadiusFunc;

    public SurfacePoolLavaGen(DependencyInjector di) {
        super(di, "infinibiome:surfaceLavaPool");
        this.chancePerChunkFunc = new IntervalMapperWrapper<BlockPos2D>(PosDataHelper.initHumidityNoise2D(di)).addBranch(PosDataHelper.DRY_INTERVAL, 0.05f, 0.037500000558793545).addBranch(Interval.union(PosDataHelper.SEMI_DRY_INTERVAL, PosDataHelper.SEMI_WET_INTERVAL), 0.037500000558793545, 0.0);
        this.lavaRadiusFunc = Helper.initUniformNoise(this.seed.newSeed("lavaRadius"), 9.0).mapInterval(new Interval(2.0, 6.0));
        this.stoneRadiusFunc = FloatFunc.constFunc(2.0);
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.LAVA_POOL;
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        double chancePerChunk = this.chancePerChunkFunc.getOutput(interChunkPos.getLowestCenterBlockPos());
        if (!MathHelper.randomBool(chancePerChunk, random)) {
            return;
        }
        BlockPos2D pos = interChunkPos.getLowestCenterBlockPos().offset(8, 8);
        SurfacePool.tryGeneratePoolAt(pos, this.getConfig(), interChunks, this.posData, random);
    }

    private SurfacePool.Config getConfig() {
        return new SurfacePool.Config(this.lavaRadiusFunc, this.stoneRadiusFunc, (pos, world, rand) -> Blocks.field_150353_l.func_176223_P(), (pos, world, rand) -> this.getStoneOrGravel(rand), (pool, world, rand) -> this.isClearOfFlammables(pool, world), (pool, world, rand) -> {
            this.addRockyEffect(pool, world, rand);
            this.clearNearbyPlantsAndSnow(pool, world);
        });
    }

    private boolean isClearOfFlammables(SurfacePool pool, IWorldReader world) {
        for (BlockPos2D currPos2D : pool.iteratePoolAndEdge(3)) {
            for (int y = pool.liquidY; y <= pool.liquidY + 3; ++y) {
                BlockPos currPos = currPos2D.to3D(y);
                BlockState currBlock = world.func_180495_p(currPos);
                if (!currBlock.isFlammable((IBlockReader)world, currPos, Direction.NORTH) || MCHelper.isPlant(currBlock.func_177230_c())) continue;
                return false;
            }
        }
        return true;
    }

    private void clearNearbyPlantsAndSnow(SurfacePool pool, IWorld world) {
        for (BlockPos2D pos : pool.iteratePoolAndEdge(3)) {
            MCHelper.clearVertically(pos.to3D(pool.liquidY), world, b -> MCHelper.isPlant(b.func_177230_c()) || b.func_177230_c().equals(Blocks.field_150433_aE));
        }
    }

    private void addRockyEffect(SurfacePool pool, IWorld world, Random random) {
        for (BlockPos2D pos : pool.iteratePoolAndEdge(1)) {
            for (int y = pool.liquidY; y <= MCHelper.getHighestTerrainHeight(pos, (IWorldReader)world); ++y) {
                BlockPos currentPos = pos.to3D(y);
                double rockyChance = 0.25 + (double)-0.025f * (double)(y - pool.liquidY);
                if (rockyChance < 0.0) {
                    rockyChance = 0.0;
                }
                if (!MCHelper.isSolid(world.func_180495_p(currentPos)) || !MathHelper.randomBool(rockyChance, random)) continue;
                world.func_180501_a(currentPos, Blocks.field_150348_b.func_176223_P(), 20);
            }
        }
    }

    private BlockState getStoneOrGravel(Random random) {
        if (MathHelper.randomBool(0.25, random)) {
            return Blocks.field_150351_n.func_176223_P();
        }
        return Blocks.field_150348_b.func_176223_P();
    }
}

