/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.modifiers.IntervalMapperWrapper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.SurfacePool;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class SurfacePoolWaterGen
extends GeneratorBase
implements InterChunkGen {
    private final FloatFunc<BlockPos2D> chancePerChunkFunc;
    private final FloatFunc<BlockPos2D> waterRadiusFunc;
    private final FloatFunc<BlockPos2D> sideRadiusFunc;

    public SurfacePoolWaterGen(DependencyInjector di) {
        super(di, "infinibiome:surfaceWaterPool");
        this.chancePerChunkFunc = new IntervalMapperWrapper<BlockPos2D>(PosDataHelper.initHumidityNoise2D(di)).addBranch(PosDataHelper.SEMI_WET_INTERVAL, 0.1f, 0.2f).addBranch(PosDataHelper.WET_INTERVAL, 0.2f, 0.5);
        this.waterRadiusFunc = Helper.initUniformNoise(this.seed, 10.0).mapInterval(new Interval(3.0, 5.0));
        this.sideRadiusFunc = FloatFunc.constFunc(2.0);
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.WATER_POOL;
    }

    private SurfacePool.Config getConfig() {
        return new SurfacePool.Config(this.waterRadiusFunc, this.sideRadiusFunc, (pos, world, rand) -> Blocks.field_150355_j.func_176223_P(), (pos, world, rand) -> this.getOuterBlock(pos, world), (pool, world, rand) -> true, (pool, world, rand) -> {});
    }

    private BlockState getOuterBlock(BlockPos pos, IWorldReader world) {
        if (world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150348_b)) {
            return Blocks.field_150348_b.func_176223_P();
        }
        return world.func_180495_p(MCHelper.to2D(pos).to3D(p -> MCHelper.getHighestTerrainHeight(p, world)));
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        BlockPos2D waterLakeCenter;
        boolean flag;
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        double chancePerChunk = this.chancePerChunkFunc.getOutput(interChunkPos.getLowestCenterBlockPos());
        if (!MathHelper.randomBool(chancePerChunk, random)) {
            return;
        }
        for (int i = 0; i < 8 && !(flag = SurfacePool.tryGeneratePoolAt(waterLakeCenter = interChunkPos.getRandomCenterPos(random), this.getConfig(), interChunks, this.posData, random)); ++i) {
        }
    }
}

