/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.LiquidsConfig;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.internal.generators.interchunks.SmallObjectGenBase;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class UndergroundPoolGen
extends SmallObjectGenBase {
    public UndergroundPoolGen(Type type, DependencyInjector di) {
        super(di, "infinibiome:undergroundPool" + type.name());
        this.config = this.initConfig().setWithFeature(Feature.field_202295_ao, type.config).setCount(1.0).setAttemptsPerCount(1).customHeightFunc((pos, world, random) -> {
            int minHeight = 10;
            int maxHeight = MCHelper.getHighestTerrainHeight(pos, (IWorldReader)world) - 10;
            if (minHeight >= maxHeight) {
                return minHeight;
            }
            return MathHelper.randomInt(minHeight, maxHeight, random);
        }).noChancePerChunk().noExtraConditions();
    }

    public static enum Type {
        WATER(DefaultBiomeFeatures.field_226736_X_),
        LAVA(DefaultBiomeFeatures.field_226737_Y_);

        private final LiquidsConfig config;

        private Type(LiquidsConfig config) {
            this.config = config;
        }
    }
}

