/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.Tags;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.generators.interchunks.SmallObjectGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class WaterDot
extends SmallObjectGenBase
implements Locatable.HasPointsProvider {
    public WaterDot(DependencyInjector di) {
        super(di, "infinibiome:waterDot");
        this.config = this.initConfig().getGenerateFunc(this::generate).setCount(64.0).setAttemptsPerCount(4).atHighestTerrainBlock().onlyInRegion(0.5).addExtraConditions(ConditionHelper.onlyInHumidity(di, PosDataHelper.WET_INTERVAL), new Condition[0]);
    }

    private void generate(BlockPos pos, IWorld world, Random random) {
        Object block = world.func_180495_p(pos);
        if (Tags.Blocks.DIRT.func_199685_a_((Object)block.func_177230_c())) {
            return;
        }
        block = world.func_180495_p(pos.func_177984_a());
        if (!MCHelper.isMostlyAir((BlockState)block)) {
            return;
        }
        for (Direction d : MCHelper.NSWE) {
            BlockState block2 = world.func_180495_p(pos.func_177972_a(d));
            if (MCHelper.isSolid(block2)) continue;
            return;
        }
        block = world.func_180495_p(pos.func_177977_b());
        if (MCHelper.isSolid((BlockState)block)) {
            return;
        }
        world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 20);
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.WATER_POOL;
    }
}

