/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.lang.reflect.Field;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.PolarBearGen;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.WolfGen;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class FoxGen
extends MobGenBase {
    private static final Field FOX_TYPE_PARAM = ObfuscationReflectionHelper.findField(FoxEntity.class, (String)"field_213523_bz");
    private DataParameter<Integer> key;

    public FoxGen(DependencyInjector di) {
        super(di, "infinibiome:fox");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(1).setBabyChance(0.05).alwaysAboveWater().neverInMushroomIsland().anyNonHighSlope().onlyOnNonBeachLand().setTemperature(GenHelper.COLDISH).anyHumidityIncludingDesert().setChancePerChunk(0.005).addExtraConditions(ConditionHelper.onlyIfNotNear(di, 2, MobGenBase::canSpawnAtInterChunk, WolfGen.class, PolarBearGen.class), new Condition[0]);
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        double temp;
        FoxEntity fox = new FoxEntity(EntityType.field_220356_B, world.func_201672_e());
        if (this.key == null) {
            try {
                this.key = (DataParameter)FOX_TYPE_PARAM.get(fox);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (PosDataHelper.FREEZE_INTERVAL.contains(temp = PosDataHelper.getTemperature(mobPos, this.posData))) {
            fox.func_184212_Q().func_187227_b(this.key, (Object)1);
        }
        return fox;
    }
}

