/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class HorseGen
extends MobGenBase {
    public HorseGen(DependencyInjector di) {
        super(di, "infinibiome:horse");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(4, 5).setBabyChance(0.2).alwaysAboveWater().neverInMushroomIsland().setSlope(new Interval(0.0, 0.5)).onlyOnNonBeachLand().anyTemperatureIncludingFreezing().setHumidity(Interval.union(PosDataHelper.SEMI_DRY_INTERVAL, PosDataHelper.SEMI_WET_INTERVAL)).setChancePerChunk(0.002).addExtraConditions(ConditionHelper.onlyInTreeDensity(di, GenHelper.NON_FORESTED_TREE_INTERVAL), new Condition[0]);
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        HorseEntity result = new HorseEntity(EntityType.field_200762_B, world.func_201672_e());
        result.func_110235_q(this.getHorseBase(interChunkPos) + this.getHorseMarking(mobPos) * 256);
        return result;
    }

    private int getHorseBase(InterChunkPos interChunkPos) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        return random.nextInt(7);
    }

    private int getHorseMarking(BlockPos horsePos) {
        Random random = this.randomGen.getRandom(horsePos.func_177958_n(), horsePos.func_177952_p());
        return random.nextInt(6);
    }
}

