/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;

public final class LlamaGen
extends MobGenBase {
    private static final int[] hotVariants = new int[]{0, 2};
    private static final int[] otherVariants = new int[]{1, 3};

    public LlamaGen(DependencyInjector di) {
        super(di, "infinibiome:llama");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(4, 5).setBabyChance(0.2).alwaysAboveWater().neverInMushroomIsland().anySlopeIncludingHigh().onlyOnNonBeachLand().anyTemperatureIncludingFreezing().setHumidity(GenHelper.DRYISH).setChancePerChunk(0.05).addExtraConditions(ConditionHelper.onlyInTreeDensity(di, GenHelper.NON_FORESTED_TREE_INTERVAL), ConditionHelper.onlyInAmp(di, new Interval(60.0, Double.POSITIVE_INFINITY)), ConditionHelper.onlyInHeight(di, new Interval(93.0, Double.POSITIVE_INFINITY)));
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        LlamaEntity result = new LlamaEntity(EntityType.field_200769_I, world.func_201672_e());
        int variant = this.getVariants(mobPos);
        result.func_190710_o(variant);
        return result;
    }

    private int getVariants(BlockPos mobPos) {
        Random random = new Random();
        double temperature = PosDataHelper.getTemperature(mobPos, this.posData);
        if (PosDataHelper.HOT_INTERVAL.contains(temperature)) {
            int randomIndex = random.nextInt(hotVariants.length);
            return hotVariants[randomIndex];
        }
        int randomIndex = random.nextInt(otherVariants.length);
        return otherVariants[randomIndex];
    }
}

