/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.floatfunc.IntFunc;
import weightedgpa.infinibiome.internal.floatfunc.generators.RandomGen;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.PredicateSearcher;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.minecraftImpl.world.NullWorld;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.misc.PosModCache;

public abstract class MobGenBase
extends GeneratorBase
implements InterChunkGen,
Locatable.HasPointsProvider {
    private static final int MAX_RETRIES = 4;
    protected Config config = null;
    private final PosModCache<InterChunkPos, Boolean> canSpawnAtInterChunk = new PosModCache<InterChunkPos, Boolean>(8, this::uncachedCanSpawnAtInterChunk, InterChunkPos.INFO);

    MobGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        DebugCommand.registerDebugFunc(seedBranch, "conditions", p -> this.config.conditions._debug((BlockPos2D)p));
    }

    boolean canSpawnAtInterChunk(InterChunkPos interChunkPos) {
        return this.canSpawnAtInterChunk.get(interChunkPos);
    }

    boolean uncachedCanSpawnAtInterChunk(InterChunkPos interChunkPos) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        double probability = this.config.conditions.getAllProbability(interChunkPos, ConditionList.StrictOption.FOUR_CORNER_CHECK);
        return MathHelper.randomBool(probability, random);
    }

    @Override
    public final Timing getInterChunkTiming() {
        return InterChunkGenTimings.MOBS;
    }

    @Override
    public final void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        if (!this.canSpawnAtInterChunk(interChunkPos)) {
            return;
        }
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        for (int i = 0; i < this.config.countFunc.getIntOutput(interChunkPos.getLowestCenterBlockPos()); ++i) {
            BlockPos2D mobPos2D;
            BlockPos mobPos;
            for (int attempt = 0; attempt < 4 && !this.trySpawnMob(mobPos = (mobPos2D = interChunkPos.getRandomCenterPos(random)).to3D(this.getHeight(mobPos2D, interChunks)), interChunkPos, interChunks, random); ++attempt) {
            }
        }
    }

    int getHeight(BlockPos2D mobPos2D, IWorld world) {
        int maxHeight = Integer.MIN_VALUE;
        for (int x = 0; x < this.getXLength(); ++x) {
            for (int z = 0; z < this.getZLength(); ++z) {
                BlockPos2D scannedPos = mobPos2D.offset(x, z);
                int scannedHeight = MCHelper.getHighestTerrainHeight(scannedPos, (IWorldReader)world) + 1;
                if (scannedHeight <= maxHeight) continue;
                maxHeight = scannedHeight;
            }
        }
        return maxHeight;
    }

    private boolean enoughAir(BlockPos mobPos3D, IWorld world) {
        for (int x = 0; x < this.getXLength(); ++x) {
            for (int y = 0; y < this.getYLength(); ++y) {
                for (int z = 0; z < this.getZLength(); ++z) {
                    BlockState block = world.func_180495_p(mobPos3D.func_177981_b(y));
                    if (!this.config.canSpawnUnderwater && MCHelper.isMostlyWater(block)) {
                        return false;
                    }
                    if (MCHelper.isMostlyAir(block) || MCHelper.isMostlyWater(block)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int getXLength() {
        return MathHelper.ceil(this.getBox().func_216364_b());
    }

    private int getYLength() {
        return MathHelper.ceil(this.getBox().func_216360_c());
    }

    private int getZLength() {
        return MathHelper.ceil(this.getBox().func_216362_d());
    }

    private AxisAlignedBB getBox() {
        return this.config.sampleEntity.func_174813_aQ();
    }

    private boolean trySpawnMob(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world, Random random) {
        if (!this.enoughAir(mobPos, world)) {
            return false;
        }
        if (world.func_180495_p(mobPos.func_177977_b()).func_185904_a().func_76224_d()) {
            return false;
        }
        this.spawnAdult(mobPos, interChunkPos, world);
        this.trySpawnBaby(mobPos, interChunkPos, world, random);
        return true;
    }

    private void spawnAdult(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        AnimalEntity mob = this.config.getEntityFunc.get(mobPos, interChunkPos, world);
        if (mob instanceof TurtleEntity) {
            // empty if block
        }
        mob.func_110163_bv();
        MCHelper.spawnEntity((Entity)mob, mobPos, world);
    }

    private void trySpawnBaby(BlockPos mobPos3D, InterChunkPos interChunkPos, IWorld world, Random random) {
        if (!MathHelper.randomBool(this.config.babyChance, random)) {
            return;
        }
        AnimalEntity baby = this.config.getEntityFunc.get(mobPos3D, interChunkPos, (IWorld)world.func_201672_e());
        baby.func_70873_a(-24000);
        baby.func_110163_bv();
        MCHelper.spawnEntity((Entity)baby, mobPos3D, world);
    }

    @Override
    public void checkIsValid() {
        Validate.notNull(this.config);
    }

    @Override
    public PointsProvider<BlockPos2D> getAllLocations() {
        return new PredicateSearcher<InterChunkPos>(1, p -> this.canSpawnAtInterChunk((InterChunkPos)p) && (this.config.canSpawnUnderwater || !this.posData.get(PosDataKeys.LANDMASS_TYPE, p.getLowestCenterBlockPos()).isOcean()), InterChunkPos.INFO).mapPoints(BlockPos2D.INFO);
    }

    Config.EntityFuncStep initConfig() {
        return new Config().new Config.EntityFuncStep();
    }

    class Config {
        private GetEntityFunc getEntityFunc;
        private AnimalEntity sampleEntity;
        private IntFunc<BlockPos2D> countFunc;
        private double babyChance;
        private boolean canSpawnUnderwater;
        ConditionList conditions = new ConditionList(new Condition[0]);

        private Config() {
        }

        class ConditionsStep {
            ConditionsStep() {
            }

            Config addExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            Config noExtraConditions() {
                return Config.this;
            }
        }

        class ChanceStep {
            ChanceStep() {
            }

            ConditionsStep setChancePerChunk(double chance) {
                Validate.isTrue(chance > 0.0);
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.chancePerChunk(chance));
                return new ConditionsStep();
            }
        }

        class HumdityStep {
            HumdityStep() {
            }

            ChanceStep anyNonDesertHumidity() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInHumidity(MobGenBase.this.di, GenHelper.NOT_DESERT));
                return new ChanceStep();
            }

            ChanceStep anyHumidityIncludingDesert() {
                return new ChanceStep();
            }

            ChanceStep setHumidity(Interval humidity) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInHumidity(MobGenBase.this.di, humidity));
                return new ChanceStep();
            }
        }

        class TemperatureStep {
            TemperatureStep() {
            }

            HumdityStep anyTemperatureIncludingFreezing() {
                return new HumdityStep();
            }

            HumdityStep anyNonFreezingTemp() {
                return this.setTemperature(GenHelper.NOT_FREEZING);
            }

            HumdityStep setTemperature(Interval temperature) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInTemperature(MobGenBase.this.di, temperature));
                return new HumdityStep();
            }
        }

        class LandmassInfoStep {
            LandmassInfoStep() {
            }

            TemperatureStep onlyOnNonBeachLand() {
                return this.setLandMass(l -> l.isLand());
            }

            TemperatureStep inLandOrBeach() {
                return this.setLandMass(l -> !l.isOcean());
            }

            TemperatureStep setLandMass(Predicate<LandmassInfo> landmassType) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInLandMass(MobGenBase.this.di, landmassType));
                return new TemperatureStep();
            }
        }

        class WalkableSlopeStep {
            WalkableSlopeStep() {
            }

            LandmassInfoStep anySlopeIncludingHigh() {
                return new LandmassInfoStep();
            }

            LandmassInfoStep anyNonHighSlope() {
                return this.anySlopeIncludingHigh();
            }

            LandmassInfoStep setSlope(Interval slope) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInSlope(MobGenBase.this.di, 15, slope));
                return new LandmassInfoStep();
            }
        }

        class MushroomIslandStep {
            MushroomIslandStep() {
            }

            WalkableSlopeStep neverInMushroomIsland() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInMushroomIsland(MobGenBase.this.di).invert());
                return new WalkableSlopeStep();
            }

            WalkableSlopeStep onlyInMushroomIsland() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInMushroomIsland(MobGenBase.this.di));
                return new WalkableSlopeStep();
            }
        }

        class UnderwaterStep {
            UnderwaterStep() {
            }

            MushroomIslandStep alwaysAboveWater() {
                Config.this.canSpawnUnderwater = false;
                return new MushroomIslandStep();
            }

            MushroomIslandStep includingUnderwater() {
                Config.this.canSpawnUnderwater = true;
                return new MushroomIslandStep();
            }
        }

        class BabyChanceStep {
            BabyChanceStep() {
            }

            UnderwaterStep setBabyChance(double chance) {
                Validate.isTrue(chance >= 0.0);
                Config.this.babyChance = chance;
                return new UnderwaterStep();
            }
        }

        class CountStep {
            CountStep() {
            }

            BabyChanceStep setGroupCount(int count) {
                return this.setGroupCount(IntFunc.constFunc(count));
            }

            BabyChanceStep setGroupCount(int minCount, int maxCount) {
                return this.setGroupCount(new RandomGen(MobGenBase.this.seed).asPercentFloatFunc(BlockPos2D.INFO).mapToIntInterval(minCount, maxCount));
            }

            BabyChanceStep setGroupCount(IntFunc<BlockPos2D> count) {
                Validate.isTrue(count.getOutputInterval().getMin() >= 1.0);
                Config.this.countFunc = count;
                return new BabyChanceStep();
            }
        }

        class EntityFuncStep {
            EntityFuncStep() {
            }

            CountStep getEntity(Function<IWorld, AnimalEntity> getEntity) {
                Config.this.getEntityFunc = (b, a, world) -> (AnimalEntity)getEntity.apply(world);
                Config.this.sampleEntity = getEntity.apply((IWorld)new NullWorld());
                return new CountStep();
            }

            CountStep getEntity(GetEntityFunc getEntityFunc) {
                Config.this.getEntityFunc = getEntityFunc;
                Config.this.sampleEntity = getEntityFunc.get(BlockPos.field_177992_a, new InterChunkPos(new ChunkPos(0, 0)), (IWorld)new NullWorld());
                return new CountStep();
            }
        }
    }

    static interface GetEntityFunc {
        public AnimalEntity get(BlockPos var1, InterChunkPos var2, IWorld var3);
    }
}

