/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class ParrotGen
extends MobGenBase {
    public ParrotGen(DependencyInjector di) {
        super(di, "infinibiome:parrot");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(1).setBabyChance(0.05).alwaysAboveWater().neverInMushroomIsland().anySlopeIncludingHigh().onlyOnNonBeachLand().anyNonFreezingTemp().anyNonDesertHumidity().setChancePerChunk(0.05).addExtraConditions(ConditionHelper.onlyInTreeDensity(di, GenHelper.FORESTED_TREE_INTERVAL), ConditionHelper.onlyInHeight(di, new Interval(93.0, Double.POSITIVE_INFINITY)), ConditionHelper.onlyInAmp(di, new Interval(60.0, Double.POSITIVE_INFINITY)));
    }

    @Override
    int getHeight(BlockPos2D mobPos2D, IWorld world) {
        return MCHelper.getHighestNonAirY(mobPos2D, (IWorldReader)world) + 1;
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        ParrotEntity result = new ParrotEntity(EntityType.field_200783_W, world.func_201672_e());
        int variant = ThreadLocalRandom.current().nextInt(5);
        result.func_191997_m(variant);
        return result;
    }
}

