/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.FoxGen;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.OcelotGen;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.PolarBearGen;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.WolfGen;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class RabbitGen
extends MobGenBase {
    public RabbitGen(DependencyInjector di) {
        super(di, "infinibiome:rabbit");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(1).setBabyChance(0.05).alwaysAboveWater().neverInMushroomIsland().anyNonHighSlope().onlyOnNonBeachLand().anyTemperatureIncludingFreezing().anyHumidityIncludingDesert().setChancePerChunk(0.05).addExtraConditions(ConditionHelper.onlyIfNotNear(di, 2, MobGenBase::canSpawnAtInterChunk, WolfGen.class, FoxGen.class, OcelotGen.class, PolarBearGen.class), new Condition[0]);
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        RabbitEntity result = new RabbitEntity(EntityType.field_200736_ab, world.func_201672_e());
        int variant = this.getRabbitType(mobPos, world);
        result.func_175529_r(variant);
        return result;
    }

    private int getRabbitType(BlockPos rabbitPos, IWorld world) {
        boolean brown = false;
        boolean white = true;
        int black = 2;
        int blackAndWhite = 3;
        int gold = 4;
        int saltAndPepper = 5;
        int killer = 99;
        Random random = this.randomGen.getRandom(rabbitPos.func_177958_n(), rabbitPos.func_177952_p());
        if (random.nextInt(100) == 0) {
            return 99;
        }
        double temperature = PosDataHelper.getTemperature(rabbitPos, this.posData);
        if (PosDataHelper.FREEZE_INTERVAL.contains(temperature)) {
            return 1;
        }
        double humidity = PosDataHelper.getHumidity(MCHelper.to2D(rabbitPos), this.posData);
        if (PosDataHelper.DRY_INTERVAL.contains(humidity)) {
            return 4;
        }
        int[] options = new int[]{0, 2, 3, 5};
        int randomIndex = random.nextInt(options.length);
        return options[randomIndex];
    }
}

