/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.apache_.commons.lang3.Validate;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.WolfGen;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class SheepGen
extends MobGenBase {
    private static final DyeColor[] WEIGHTED_DYE_COLORS;

    public SheepGen(DependencyInjector di) {
        super(di, "infinibiome:sheep");
        this.config = this.initConfig().getEntity(this::getEntity).setGroupCount(2, 3).setBabyChance(0.05).alwaysAboveWater().neverInMushroomIsland().anyNonHighSlope().onlyOnNonBeachLand().anyTemperatureIncludingFreezing().anyNonDesertHumidity().setChancePerChunk(0.04).addExtraConditions(ConditionHelper.chancePerChunk(0.7).activeOutside(ConditionHelper.onlyInTemperature(di, GenHelper.COLDISH)), ConditionHelper.chancePerChunk(0.7).activeOutside(ConditionHelper.onlyInTreeDensity(di, GenHelper.FORESTED_TREE_INTERVAL)), ConditionHelper.onlyIfNotNear(di, 2, MobGenBase::canSpawnAtInterChunk, WolfGen.class));
    }

    private AnimalEntity getEntity(BlockPos mobPos, InterChunkPos interChunkPos, IWorld world) {
        SheepEntity result = new SheepEntity(EntityType.field_200737_ac, world.func_201672_e());
        result.func_175512_b(this.getSheepColor(MCHelper.to2D(mobPos)));
        return result;
    }

    private DyeColor getSheepColor(BlockPos2D pos) {
        Random random = this.randomGen.getRandom(pos.getBlockX(), pos.getBlockZ());
        int randomIndex = random.nextInt(WEIGHTED_DYE_COLORS.length);
        return WEIGHTED_DYE_COLORS[randomIndex];
    }

    static {
        ArrayList<DyeColor> weightedDyeColor = new ArrayList<DyeColor>();
        weightedDyeColor.addAll(Collections.nCopies(820, DyeColor.WHITE));
        weightedDyeColor.addAll(Collections.nCopies(50, DyeColor.BLACK));
        weightedDyeColor.addAll(Collections.nCopies(50, DyeColor.GRAY));
        weightedDyeColor.addAll(Collections.nCopies(50, DyeColor.GRAY));
        weightedDyeColor.addAll(Collections.nCopies(29, DyeColor.BROWN));
        weightedDyeColor.addAll(Collections.nCopies(1, DyeColor.PINK));
        WEIGHTED_DYE_COLORS = weightedDyeColor.toArray(new DyeColor[0]);
        Validate.isTrue(WEIGHTED_DYE_COLORS.length == 1000);
    }
}

