/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.mob;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.TurtleEntity;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.generators.interchunks.mob.MobGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.Helper;

public final class TurtleGen
extends MobGenBase {
    public TurtleGen(DependencyInjector di) {
        super(di, "infinibiome:turtle");
        this.config = this.initConfig().getEntity(w -> new TurtleEntity(EntityType.field_203099_aq, w.func_201672_e())).setGroupCount(1).setBabyChance(0.0).includingUnderwater().neverInMushroomIsland().anySlopeIncludingHigh().setLandMass(l -> !l.isLand()).anyTemperatureIncludingFreezing().anyHumidityIncludingDesert().setChancePerChunk(0.02).addExtraConditions(ConditionHelper.chancePerChunk(0.5).activeOutside(ConditionHelper.onlyInLandMass(di, l -> l.getTransitionToBeach() > 0.8)), new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                List<BlockState> groundBlocks = TurtleGen.this.posData.get(PosDataKeys.GROUND_BLOCKS, pos);
                if (groundBlocks.isEmpty()) {
                    return false;
                }
                return groundBlocks.get(0).func_177230_c().equals(Blocks.field_150354_m);
            }

            public String toString() {
                return "CheckSandy{}";
            }
        }, new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                return TurtleGen.this.nearOcean(pos);
            }

            @Override
            public boolean isSlow() {
                return true;
            }

            public String toString() {
                return "CheckNotInland{}";
            }
        });
    }

    private boolean nearOcean(BlockPos2D pos) {
        return Helper.findSuitableSpot(pos, 100, this::inOcean, BlockPos2D.INFO) != null;
    }

    private boolean inOcean(BlockPos2D pos) {
        return this.posData.get(PosDataKeys.MAPPED_HEIGHT, pos) < 47.0;
    }
}

