/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.Seed;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public final class CactusGen
extends PlantGenBase {
    private final Predicate<BlockPos2D> extraCactusHeight;

    public CactusGen(DependencyInjector di) {
        super(di, "infinibiome:cactus");
        this.config = this.initConfig().setPlantBlockFunc(this::getPlantBlocks).setSampleBlock(Blocks.field_150434_aF).setAboveWater().setScatteredRate(new Interval(0.0, 8.0)).neverInMushroomIsland().anyTemperatureIncludingFreezing().setHumdity(GenHelper.DRYISH).setSpawnRegion(0.9000000357627869).setExtraConditions(ConditionHelper.onlyInLandMass(di, LandmassInfo::isLand), new Condition[0]).setBoneMealPlantFunc(this::getPlantBlocksOnBoneMeal);
        this.extraCactusHeight = this.initCactusExtraHeightChance(this.seed);
    }

    private Predicate<BlockPos2D> initCactusExtraHeightChance(Seed seed) {
        seed = seed.newSeed("extraCactusHeight");
        return Helper.initUniformNoise(seed, 2048.0).randomBool(BlockPos2D.INFO, seed);
    }

    private List<BlockState> getPlantBlocks(BlockPos plantPos, IWorldReader world, Random random) {
        int height = this.extraCactusHeight.test(MCHelper.to2D(plantPos)) ? 4 : 3;
        if (!CactusGen.surroundedByAir(plantPos, height, world)) {
            return Collections.emptyList();
        }
        return Collections.nCopies(height, Blocks.field_150434_aF.func_176223_P());
    }

    private List<BlockState> getPlantBlocksOnBoneMeal(BlockPos plantPos, IWorldReader world, Random random) {
        if (!CactusGen.surroundedByAir(plantPos, 1, world)) {
            return Collections.emptyList();
        }
        if (world.func_180495_p(plantPos.func_177977_b()).func_177230_c().equals(Blocks.field_150434_aF)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new BlockState[]{Blocks.field_150434_aF.func_176223_P()});
    }

    private static boolean surroundedByAir(BlockPos pos, int height, IWorldReader world) {
        for (int y = 0; y <= height; ++y) {
            for (Direction d : MCHelper.NSWE) {
                BlockPos currPos = pos.func_177981_b(y).func_177972_a(d);
                BlockState currBlock = world.func_180495_p(currPos);
                if (MCHelper.isMostlyAir(currBlock)) continue;
                return false;
            }
        }
        return true;
    }
}

