/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.KelpTopBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class KelpeGen
extends PlantGenBase {
    public KelpeGen(DependencyInjector di) {
        super(di, "infinibiome:kelpe");
        this.config = this.initConfig().setPlantBlockFunc(this::getPlantBlocks).setSampleBlock(Blocks.field_203215_jy).setUnderwater().setScatteredRate(new Interval(0.1, 0.5)).alsoInMushroomIsland().anyNonFreezingTemperature().anyHumidity().setNoSpawnRegion().setExtraConditions(ConditionHelper.onlyInLandMass(di, LandmassInfo::isOcean), new Condition[0]).setBoneMealPlantFunc(this::getPlantBlocksOnBoneMeal);
    }

    private List<BlockState> getPlantBlocks(BlockPos plantPos, IWorldReader world, Random random) {
        ArrayList<BlockState> result = new ArrayList<BlockState>();
        int height = MathHelper.randomInt(2, 25, random);
        for (int y = 0; y < height && world.func_180495_p(plantPos.func_177981_b(y)).func_177230_c().equals(Blocks.field_150355_j); ++y) {
            result.add(Blocks.field_203215_jy.func_176223_P());
        }
        if (result.size() < 2) {
            return Collections.emptyList();
        }
        result.set(result.size() - 1, (BlockState)Blocks.field_203214_jx.func_176223_P().func_206870_a((IProperty)KelpTopBlock.field_203163_a, (Comparable)Integer.valueOf(25)));
        return result;
    }

    List<BlockState> getPlantBlocksOnBoneMeal(BlockPos plantPos, IWorldReader world, Random random) {
        return Lists.newArrayList((Object[])new BlockState[]{Blocks.field_203214_jx.func_176223_P()});
    }
}

