/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public final class MushroomSmallUndergroundGen
extends GeneratorBase
implements InterChunkGen {
    private static final int MIN_HEIGHT = 16;
    private static final double CHANCE_PER_CHUNK = (double)0.8f;
    private static final double DENSITY = 0.25;
    private static final FloatFunc<BlockPos2D> radiusFunc = FloatFunc.constFunc(2.0);

    public MushroomSmallUndergroundGen(DependencyInjector di) {
        super(di, "infinibiome:mushroomSmallUnderground");
    }

    @Override
    public Timing getInterChunkTiming() {
        return InterChunkGenTimings.PLANTS;
    }

    @Override
    public void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        if (MathHelper.randomBool(0.8f, random)) {
            return;
        }
        BlockPos2D centerPos = interChunkPos.getRandomCenterPos(random);
        this.generatePlant(centerPos, interChunks, random);
    }

    private void generatePlant(BlockPos2D center2D, IWorld world, Random random) {
        Integer centerHeight = this.getClusterCenterHeight(center2D, (IWorldReader)world, random);
        if (centerHeight == null) {
            return;
        }
        BlockPos center = center2D.to3D(centerHeight);
        BlockState plantBlock = this.getPlantBlock(random);
        Helper.placeClusterWithUnknownHeight(center, radiusFunc, (IWorldReader)world, p -> {
            if (p.func_177956_o() >= MCHelper.getHighestTerrainHeight(MCHelper.to2D(p), (IWorldReader)world)) {
                return;
            }
            if (!MathHelper.randomBool(0.25, random)) {
                return;
            }
            world.func_180501_a(p, plantBlock, 20);
        });
    }

    @Nullable
    private Integer getClusterCenterHeight(BlockPos2D centerPos, IWorldReader world, Random random) {
        IntArrayList validPos = new IntArrayList();
        for (int y = 16; y <= MCHelper.getHighestNonAirY(centerPos, world); ++y) {
            BlockPos scanPos = centerPos.to3D(y);
            if (!MCHelper.isMostlyAir(world.func_180495_p(scanPos)) || !MCHelper.isSolid(world.func_180495_p(scanPos.func_177977_b()))) continue;
            validPos.add(y);
        }
        if (validPos.isEmpty()) {
            return null;
        }
        return validPos.getInt(random.nextInt(validPos.size()));
    }

    private BlockState getPlantBlock(Random random) {
        if (random.nextBoolean()) {
            return Blocks.field_150337_Q.func_176223_P();
        }
        return Blocks.field_150338_P.func_176223_P();
    }
}

