/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.apache_.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.generators.InterChunkGen;
import weightedgpa.infinibiome.api.generators.InterChunkGenTimings;
import weightedgpa.infinibiome.api.generators.PlantGrowthConfig;
import weightedgpa.infinibiome.api.generators.Timing;
import weightedgpa.infinibiome.api.generators.nonworldgen.GroundBoneMealController;
import weightedgpa.infinibiome.api.generators.nonworldgen.Locatable;
import weightedgpa.infinibiome.api.generators.nonworldgen.PlantGrowthController;
import weightedgpa.infinibiome.api.pointsprovider.PointsProvider;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.InterChunkPos;
import weightedgpa.infinibiome.internal.floatfunc.FloatFunc;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantHelper;
import weightedgpa.infinibiome.internal.generators.utils.GenHelper;
import weightedgpa.infinibiome.internal.generators.utils.GeneratorBase;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.ConditionList;
import weightedgpa.infinibiome.internal.minecraftImpl.commands.DebugCommand;
import weightedgpa.infinibiome.internal.minecraftImpl.world.ClientUpdatingWorld;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

abstract class PlantGenBase
extends GeneratorBase
implements InterChunkGen,
GroundBoneMealController,
PlantGrowthController,
Locatable.HasPointsProvider {
    protected Config config;
    private final PlantGrowthConfig growthConfig;
    private static final List<Block> grassBlocks = Lists.newArrayList((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_196804_gh, Blocks.field_196554_aH, Blocks.field_196805_gi, Blocks.field_203198_aQ, Blocks.field_203199_aR});

    PlantGenBase(DependencyInjector di, String seedBranch) {
        super(di, seedBranch);
        this.growthConfig = di.get(PlantGrowthConfig.class);
        DebugCommand.registerDebugFunc(seedBranch, "groupCount", p -> this.getGroupCount(new InterChunkPos((BlockPos2D)p)));
        DebugCommand.registerDebugFunc(seedBranch, "rate", p -> this.config.rateFunc.getOutput(p) * this.config.conditions.getAllProbability((BlockPos2D)p, ConditionList.StrictOption.USE_LIKE_NON_STRICT));
        DebugCommand.registerDebugFunc(seedBranch, "funcRate", p -> this.config.rateFunc.getOutput(p));
        DebugCommand.registerDebugFunc(seedBranch, "conditions", p -> this.config.conditions._debug((BlockPos2D)p));
    }

    @Override
    public final Timing getInterChunkTiming() {
        return InterChunkGenTimings.PLANTS;
    }

    @Override
    public final void generate(InterChunkPos interChunkPos, IWorld interChunks) {
        Random random = this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ());
        int count = this.getGroupCount(interChunkPos);
        double radius = Interval.PERCENT.mapInterval(random.nextFloat(), this.config.radius);
        double density = Interval.PERCENT.mapInterval(random.nextFloat(), this.config.density);
        double radiusSq = Math.pow(radius, 2.0);
        int radiusCeil = MathHelper.ceil(radius);
        for (int i = 0; i < count; ++i) {
            BlockPos2D clusterCenter = interChunkPos.getRandomCenterPos(random);
            for (int x = -radiusCeil; x <= radiusCeil; ++x) {
                for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                    BlockPos2D plantPos2D = clusterCenter.offset(x, z);
                    if (!MathHelper.randomBool(density, random) || MathHelper.getDistanceSq(BlockPos2D.INFO, clusterCenter, plantPos2D) > radiusSq) continue;
                    int plantY = this.getPlantY(plantPos2D, (IWorldReader)interChunks);
                    BlockPos plantPos = plantPos2D.to3D(plantY);
                    this.tryPlacePlant(plantPos, interChunks, random, false);
                }
            }
        }
    }

    private int getGroupCount(InterChunkPos interChunkPos) {
        double result = 1.0;
        if ((result *= this.config.conditions.getAllProbability(interChunkPos, ConditionList.StrictOption.EXCLUDE)) == 0.0) {
            return 0;
        }
        if ((result *= this.config.rateFunc.getOutput(interChunkPos.getLowestCenterBlockPos())) == 0.0) {
            return 0;
        }
        return MathHelper.randomRound(result, this.randomGen.getRandom(interChunkPos.getX(), interChunkPos.getZ()));
    }

    private int getPlantY(BlockPos2D pos, IWorldReader world) {
        if (this.config.spawnsUnderwater) {
            return MCHelper.getHighestTerrainHeight(pos, world) + 1;
        }
        return MCHelper.getHighestSurfaceHeight(pos, world) + 1;
    }

    private boolean tryPlacePlant(BlockPos plantPos, IWorld world, Random random, boolean isBoneMealed) {
        List<BlockState> plantBlocks = !isBoneMealed ? this.config.plantBlockFunc.get(plantPos, (IWorldReader)world, random) : this.config.boneMealPlantBlockFunc.get(plantPos, (IWorldReader)world, random);
        if (!this.isValidAt(plantBlocks, plantPos, (IWorldReader)world, random, isBoneMealed)) {
            return false;
        }
        this.placePlantBlocks(plantBlocks, plantPos, world, isBoneMealed);
        return true;
    }

    private boolean isValidAt(List<@Nullable BlockState> plantBlocks, BlockPos plantPos, IWorldReader world, Random random, boolean isBoneMealed) {
        if (plantBlocks.isEmpty()) {
            return false;
        }
        if (this.allNull(plantBlocks)) {
            return false;
        }
        double specificProbability = this.config.conditions.getAllProbability(MCHelper.to2D(plantPos), ConditionList.StrictOption.ONLY);
        if (!MathHelper.randomBool(specificProbability, random)) {
            return false;
        }
        if (!this.config.checkGroundFunc.test(plantPos.func_177977_b(), world)) {
            return false;
        }
        return this.isValidSpace(plantBlocks, plantPos, world, isBoneMealed);
    }

    private boolean allNull(List<@Nullable BlockState> plantBlocks) {
        for (BlockState block : plantBlocks) {
            if (block == null) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSpace(List<@Nullable BlockState> plantBlocks, BlockPos plantPos, IWorldReader world, boolean isBoneMealed) {
        for (int y = 0; y < plantBlocks.size(); ++y) {
            if (plantBlocks.get(y) == null) continue;
            BlockPos scanPos = plantPos.func_177981_b(y);
            BlockState block = world.func_180495_p(scanPos);
            if (!this.canOverrideBlock(block, isBoneMealed)) {
                return false;
            }
            if (!this.config.spawnsUnderwater || !PlantHelper.iceAtPos(scanPos, world, this.posData)) continue;
            return false;
        }
        return true;
    }

    private boolean canOverrideBlock(BlockState block, boolean boneMealed) {
        boolean isAir = block.func_177230_c().equals(Blocks.field_150350_a);
        boolean isMostlyAir = MCHelper.isMostlyAir(block);
        boolean isSnow = block.func_177230_c().equals(Blocks.field_150433_aE);
        boolean isWater = block.func_177230_c().equals(Blocks.field_150355_j);
        boolean isMostlyWater = MCHelper.isMostlyWater(block);
        boolean isPlant = MCHelper.isPlant(block.func_177230_c());
        boolean isGrass = grassBlocks.contains(block.func_177230_c());
        if (!this.config.spawnsUnderwater) {
            if (!isMostlyAir) {
                return false;
            }
            if (!boneMealed && this.config.canOverridePlants) {
                return isPlant || isAir || isSnow;
            }
            return isGrass || isAir || isSnow;
        }
        if (!isMostlyWater) {
            return false;
        }
        if (!boneMealed && this.config.canOverridePlants) {
            return isPlant || isWater;
        }
        return isGrass || isWater;
    }

    private void placePlantBlocks(List<@Nullable BlockState> plantBlocks, BlockPos plantPos, IWorld world, boolean isBoneMealed) {
        MCHelper.clearVertically(plantPos, world, b -> this.canOverrideBlock((BlockState)b, isBoneMealed));
        for (int y = 0; y < plantBlocks.size(); ++y) {
            BlockState plantBlock = plantBlocks.get(y);
            if (plantBlock == null) continue;
            world.func_180501_a(plantPos.func_177981_b(y), plantBlock, 20);
        }
        this.fixSnowyBlock(plantPos, world);
    }

    private void fixSnowyBlock(BlockPos plantPos, IWorld world) {
        BlockState block = world.func_180495_p(plantPos.func_177977_b());
        if (block.func_196959_b((IProperty)SnowyDirtBlock.field_196382_a) && ((Boolean)block.func_177229_b((IProperty)SnowyDirtBlock.field_196382_a)).booleanValue()) {
            world.func_180501_a(plantPos.func_177977_b(), (BlockState)block.func_206870_a((IProperty)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(false)), 20);
        }
    }

    @Override
    public final boolean controlsPlant(BlockState block, boolean is2x2) {
        Object controlledBlock = this.config.sampleBlock instanceof StemGrownBlock ? ((StemGrownBlock)this.config.sampleBlock).func_196524_d() : this.config.sampleBlock;
        return controlledBlock.equals(block.func_177230_c());
    }

    @Override
    public final boolean isValidGrowth(BlockPos pos, IWorld world) {
        boolean canDuplicate = BlockTags.field_226148_H_.func_199685_a_((Object)this.config.sampleBlock);
        if (canDuplicate) {
            return this.growthConfig.allowFlowerDuplication;
        }
        if (this.isGrowable(pos, world)) {
            return true;
        }
        if (this.config.sampleBlock instanceof SugarCaneBlock) {
            return true;
        }
        return this.config.sampleBlock instanceof CactusBlock;
    }

    private boolean isGrowable(BlockPos pos, IWorld world) {
        Object growingBlock = this.config.sampleBlock instanceof StemGrownBlock ? ((StemGrownBlock)this.config.sampleBlock).func_196524_d() : this.config.sampleBlock;
        if (!(growingBlock instanceof IGrowable)) {
            return false;
        }
        return ((IGrowable)growingBlock).func_176473_a((IBlockReader)world, pos, world.func_180495_p(pos), false);
    }

    @Override
    public final boolean canGrowWithBonemeal(BlockPos pos, IWorld world, Random random) {
        if (this.growthConfig.allowPlantUniformGrowth) {
            return true;
        }
        if (this.config.conditions.canBeHere(MCHelper.to2D(pos))) {
            return true;
        }
        return MathHelper.randomBool(0.25, random);
    }

    @Override
    public final double getGroundBonemealChance(BlockPos2D pos) {
        double density;
        if (!this.config.conditions.canBeHere(pos)) {
            return 0.0;
        }
        double radius = this.config.radius.getMidPoint();
        double approxCount = (radius + 0.5) * (radius + 0.5) * Math.PI * (density = this.config.density.getMidPoint());
        if (approxCount == 0.0) {
            return 0.0;
        }
        return 1.0 / approxCount * 1.0 / 4.0;
    }

    @Override
    public final void spawnFromGroundBoneMeal(BlockPos centerPos, IWorld world, Random random) {
        world = new ClientUpdatingWorld(world);
        BlockPos2D centerPos2D = MCHelper.to2D(centerPos);
        if (!this.config.conditions.canBeHere(MCHelper.to2D(centerPos))) {
            return;
        }
        if (!this.tryPlacePlant(centerPos, world, random, true)) {
            return;
        }
        double radius = Interval.PERCENT.mapInterval(random.nextFloat(), this.config.radius);
        double density = Interval.PERCENT.mapInterval(random.nextFloat(), this.config.density);
        IWorld finalWorld = world;
        Helper.placeClusterWithUnknownHeight(centerPos, FloatFunc.constFunc(radius), (IWorldReader)world, p -> {
            if (MCHelper.to2D(p).equals(centerPos2D)) {
                return;
            }
            if (!MathHelper.randomBool(density, random)) {
                return;
            }
            this.tryPlacePlant((BlockPos)p, finalWorld, random, true);
        });
    }

    @Override
    public final void checkIsValid() {
        Validate.notNull(this.config);
    }

    @Override
    public final PointsProvider<BlockPos2D> getAllLocations() {
        return GenHelper.getCommonPredicateSearcher(32, this.config.spawnsUnderwater, this.config.conditions, this.posData);
    }

    Config.PlantGenStep initConfig() {
        return new Config().new Config.PlantGenStep();
    }

    class Config {
        private PlantBlockFunc plantBlockFunc;
        private PlantBlockFunc boneMealPlantBlockFunc;
        private Block sampleBlock;
        private FloatFunc<BlockPos2D> rateFunc;
        private Interval radius;
        private Interval density;
        private boolean spawnsUnderwater = false;
        private boolean canOverridePlants = true;
        private BiPredicate<BlockPos, IWorldReader> checkGroundFunc = (groundPos, world) -> PlantGenBase.this.config.sampleBlock.func_176223_P().func_196955_c(world, groundPos.func_177984_a());
        ConditionList conditions = new ConditionList(new Condition[0]);

        Config() {
        }

        Config setNoGroundBoneMeal() {
            this.boneMealPlantBlockFunc = (a, b, c) -> Collections.emptyList();
            return this;
        }

        Config setBoneMealPlantFunc(PlantBlockFunc plantBlockFunc) {
            this.boneMealPlantBlockFunc = plantBlockFunc;
            return this;
        }

        Config setCantOverridePlants() {
            this.canOverridePlants = false;
            return this;
        }

        Config setNoGroundCheck() {
            return this.setCheckGroundFunc((blockPos, worldReader) -> true);
        }

        Config setCheckOnlyDirt() {
            return this.setCheckGroundFunc((groundPos, worldReader) -> {
                Block groundBlock = worldReader.func_180495_p(groundPos).func_177230_c();
                return Arrays.asList(Blocks.field_196658_i, Blocks.field_196661_l, Blocks.field_196660_k).contains(groundBlock);
            });
        }

        Config setCheckGroundFunc(BiPredicate<BlockPos, IWorldReader> checkGroundFunc) {
            this.checkGroundFunc = checkGroundFunc;
            return this;
        }

        class ConditionStep {
            ConditionStep() {
            }

            Config setExtraConditions(Condition extraCondition0, Condition ... extraConditions) {
                Config.this.conditions = Config.this.conditions.add(extraCondition0);
                Config.this.conditions = Config.this.conditions.add(extraConditions);
                return Config.this;
            }

            Config setNoExtraConditions() {
                return Config.this;
            }
        }

        class RegionStep {
            RegionStep() {
            }

            ConditionStep setSpawnRegion(double rate) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInRegion(PlantGenBase.this.seed, rate));
                return new ConditionStep();
            }

            ConditionStep setNoSpawnRegion() {
                return new ConditionStep();
            }
        }

        class HumidityStep {
            HumidityStep() {
            }

            RegionStep anyHumidity() {
                return new RegionStep();
            }

            RegionStep setHumdity(Interval interval) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInHumidity(PlantGenBase.this.di, interval));
                return new RegionStep();
            }
        }

        class TemperatureStep {
            TemperatureStep() {
            }

            HumidityStep anyNonFreezingTemperature() {
                return this.setTemperature(GenHelper.NOT_FREEZING);
            }

            HumidityStep setTemperature(Interval intervals) {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInTemperature(PlantGenBase.this.di, intervals));
                return new HumidityStep();
            }

            public HumidityStep anyTemperatureIncludingFreezing() {
                return new HumidityStep();
            }
        }

        class MushroomIslandStep {
            MushroomIslandStep() {
            }

            TemperatureStep neverInMushroomIsland() {
                Config.this.conditions = Config.this.conditions.add(ConditionHelper.onlyInMushroomIsland(PlantGenBase.this.di).invert());
                return new TemperatureStep();
            }

            TemperatureStep alsoInMushroomIsland() {
                return new TemperatureStep();
            }
        }

        class DensityStep {
            DensityStep() {
            }

            MushroomIslandStep setDensity(Interval density) {
                Validate.isTrue(Interval.PERCENT.containsAll(density));
                Config.this.density = density;
                return new MushroomIslandStep();
            }

            MushroomIslandStep setWithCommonDensity() {
                return this.setDensity(PlantHelper.COMMON_DENSITY);
            }
        }

        class RadiusStep {
            RadiusStep() {
            }

            DensityStep setRadius(Interval radius) {
                Validate.isTrue(new Interval(0.0, 7.0).containsAll(radius));
                Config.this.radius = radius;
                return new DensityStep();
            }

            DensityStep setWithCommonRadius() {
                return this.setRadius(PlantHelper.COMMON_RADIUS);
            }
        }

        class RateStep {
            RateStep() {
            }

            RadiusStep setRate(FloatFunc<BlockPos2D> rateFunc) {
                Validate.isTrue(new Interval(0.0, 255.0).containsAll(rateFunc.getOutputInterval()));
                Config.this.rateFunc = rateFunc;
                return new RadiusStep();
            }

            RadiusStep setRate(Interval rate) {
                return this.setRate(PlantHelper.getRateFunc(PlantGenBase.this.seed, rate, 0.0));
            }

            RadiusStep setWithCommonRate() {
                return this.setRate(PlantHelper.getCommonClusterRateFunc(PlantGenBase.this.seed));
            }

            MushroomIslandStep setScatteredRate(Interval interval) {
                return this.setScatteredRate(PlantHelper.getRateFunc(PlantGenBase.this.seed, interval, -5.0));
            }

            MushroomIslandStep setScatteredRate(FloatFunc<BlockPos2D> rateFunc) {
                return this.setRate(rateFunc).setRadius(PlantHelper.SCATTERED_RADIUS).setDensity(PlantHelper.SCATTERED_DENSITY);
            }
        }

        class UnderwaterStep {
            UnderwaterStep() {
            }

            RateStep setAboveWater() {
                Config.this.spawnsUnderwater = false;
                return new RateStep();
            }

            RateStep setUnderwater() {
                Config.this.spawnsUnderwater = true;
                return new RateStep();
            }
        }

        class SampleStep {
            SampleStep() {
            }

            UnderwaterStep setSampleBlock(Block sampleBlock) {
                Config.this.sampleBlock = sampleBlock;
                if (sampleBlock.getBlock() instanceof StemGrownBlock) {
                    Config.this.setCheckOnlyDirt();
                }
                return new UnderwaterStep();
            }
        }

        class PlantGenStep {
            PlantGenStep() {
            }

            UnderwaterStep setPlant(Block plantBlock) {
                return this.setPlant(plantBlock.func_176223_P());
            }

            UnderwaterStep setPlant(BlockState plantBlock) {
                ImmutableList plantBlocks = plantBlock.func_196959_b((IProperty)DoublePlantBlock.field_176492_b) ? ImmutableList.of((Object)plantBlock.func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER), (Object)plantBlock.func_206870_a((IProperty)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER)) : ImmutableList.of((Object)plantBlock);
                return this.setPlant((List<BlockState>)plantBlocks);
            }

            UnderwaterStep setPlant(List<BlockState> plantBlocks) {
                assert (!plantBlocks.isEmpty());
                Config.this.plantBlockFunc = (a, b, c) -> plantBlocks;
                Config.this.boneMealPlantBlockFunc = Config.this.plantBlockFunc;
                return new SampleStep().setSampleBlock(plantBlocks.get(0).func_177230_c());
            }

            SampleStep setPlantBlockFunc(PlantBlockFunc plantBlockFunc) {
                Config.this.plantBlockFunc = plantBlockFunc;
                Config.this.boneMealPlantBlockFunc = (pos, world, rand) -> Collections.emptyList();
                return new SampleStep();
            }
        }
    }

    @FunctionalInterface
    static interface PlantBlockFunc {
        public List<@Nullable BlockState> get(BlockPos var1, IWorldReader var2, Random var3);
    }
}

