/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.generators.interchunks.plant;

import net.minecraft.block.Blocks;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.GrassType;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantGenBase;
import weightedgpa.infinibiome.internal.generators.interchunks.plant.PlantHelper;
import weightedgpa.infinibiome.internal.generators.utils.condition.Condition;

public final class SeaGrassGen
extends PlantGenBase {
    private final GrassType type;

    public SeaGrassGen(GrassType type, DependencyInjector di) {
        super(di, "infinibiome:seaGrass" + type.name());
        this.config = this.initConfig().setPlant(type.getShortOrTall(() -> Blocks.field_203198_aQ, () -> Blocks.field_203199_aR)).setUnderwater().setRate(type.clusteredOrScattered(() -> PlantHelper.getCommonClusterRateFunc(this.seed), () -> PlantHelper.getRateFunc(this.seed, new Interval(0.0, 128.0), -5.0))).setRadius(type.clusteredOrScattered(() -> PlantHelper.COMMON_RADIUS, () -> PlantHelper.SCATTERED_RADIUS)).setDensity(type.clusteredOrScattered(() -> PlantHelper.COMMON_DENSITY, () -> PlantHelper.SCATTERED_DENSITY)).alsoInMushroomIsland().anyTemperatureIncludingFreezing().anyHumidity().setNoSpawnRegion().setExtraConditions(new Condition.BoolInterpolated(){

            @Override
            public boolean passes(BlockPos2D pos) {
                return SeaGrassGen.this.posData.get(PosDataKeys.LANDMASS_TYPE, pos).isOcean() || PosDataHelper.isUnderwaterPortionOfLakeOrRiver(pos, SeaGrassGen.this.posData);
            }
        }, new Condition[0]);
        this.type = type;
    }

    public String toString() {
        return "SeaGrass{type=" + (Object)((Object)this.type) + '}';
    }
}

